% Script createHDR
% function createHDR
% create HDR image from several exposure 16-bit TIFF mosaic images
% folder_name: folder containing the images to process. Images must be
% named with an index from lowest exposure to highest exposure
% exposure: .mat file containing the exposure time and aperture for
% each image, from lowest exposure to highest exposure. size (# 2)
%
% Remarks:
% - shot noise is removed first
% - inverse OECF can be applied to the images prior to HDR image creation
% - TIFF files are created with dcraw with the following command line:
% dcraw -v -T -D -4 imageName
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% -----------------------------------------------------------------------
% Digital Camera Workflow for HDR images using a model of retinal
% processing
% Written by Daniel Tamburrino, David Alleysson and Laurence Meylan
% Copyright (C) 2007-2008 Laboratory of Audiovisual Communications (LCAV), 
% Ecole Polytechnique Federale de Lausanne (EPFL), 
% CH-1015 Lausanne, Switzerland 
% 
% This program is free software; you can redistribute it and/or modify it 
% under the terms of the GNU General Public License as published by the 
% Free Software Foundation; either version 2 of the License, or (at your 
% option) any later version. This software is distributed in the hope that 
% it will be useful, but without any warranty; without even the implied 
% warranty of merchantability or fitness for a particular purpose. 
% See the GNU General Public License for more details 
% (enclosed in the file GPL).  
%
% Latest modifications: December 31, 2007, by Daniel Tamburrino

global DISPLAY
global filename

folder_name = filename;
% load texp vector of exposure times
load ([folder_name '/texp.mat'])

%% Load the data and metadata in the struct im
path(path, folder_name)
d = dir(['./' folder_name '/*.tif*']);
N=length(d); % Number of images
if (N==0)
    error('createHDR: no TIFF files in specified folder. File name must be .tif or .tiff')
end

for i=1:N
    im(:,:,i)=double(imread(d(i).name));
    fprintf (['file ' num2str(i) ' loaded \n'])
end

%% remove noise offset
for i=1:N
    im(:,:,i)=im(:,:,i)-min(min(im(:,:,i)));
end

%% call makehdr function
out=mergeHDR(im,texp,0.04,0.96);
clear im
%write file to disk
%imwrite(uint16(out*(2^16)),[d(1).name '_hdr.tiff'],'tiff')

%% white balancing


wb_coefs=setWB(out,'350D');

out = wb(out,wb_coefs,'350D');

%% save image
save ([folder_name '/makeHDR_out.mat'], 'out')

