function Out = cc(In,camera)
% function Out=cc(In)
% performs color correction from cRGB to sRGB for a specific camera

%% -----------------------------------------------------------------------
% Digital Camera Workflow for HDR images using a model of retinal
% processing
% Written by Daniel Tamburrino, David Alleysson and Laurence Meylan
% Copyright (C) 2007-2008 Laboratory of Audiovisual Communications (LCAV), 
% Ecole Polytechnique Federale de Lausanne (EPFL), 
% CH-1015 Lausanne, Switzerland 
% 
% This program is free software; you can redistribute it and/or modify it 
% under the terms of the GNU General Public License as published by the 
% Free Software Foundation; either version 2 of the License, or (at your 
% option) any later version. This software is distributed in the hope that 
% it will be useful, but without any warranty; without even the implied 
% warranty of merchantability or fitness for a particular purpose. 
% See the GNU General Public License for more details 
% (enclosed in the file GPL).  
%
% Latest modifications: December 10, 2007, by Daniel Tamburrino


%% reshape input
s = size(In);
% im=reshape(In,s(1)*s(2),s(3))';
% using a function instead:
im=im2v(In);
clear In

%% Get the transformation matrix M to transorm cRGB to XYZ under D65
M=getM('D65',camera); 


%% XYZ to sRGB conversion matrix:
Ms = [3.2410 -1.5374 -0.4986; -0.9692 1.8760 0.0416; 0.0556 -0.2040 1.0570];
M=Ms*M;
Out=M*im;
clear im

% reshape
% out=reshape(out',s(1),s(2),s(3));
Out=im2m(Out,s);
%imshow(Out,[])

 