function Out=GanglionLocalNL(In)
% function Out=GanglionLocalNL(In)
% apply photoreceptor non-linearity

%% -----------------------------------------------------------------------
% Digital Camera Workflow for HDR images using a model of retinal
% processing
% Written by Daniel Tamburrino, David Alleysson and Laurence Meylan
% Copyright (C) 2007-2008 Laboratory of Audiovisual Communications (LCAV), 
% Ecole Polytechnique Federale de Lausanne (EPFL), 
% CH-1015 Lausanne, Switzerland 
% 
% This program is free software; you can redistribute it and/or modify it 
% under the terms of the GNU General Public License as published by the 
% Free Software Foundation; either version 2 of the License, or (at your 
% option) any later version. This software is distributed in the hope that 
% it will be useful, but without any warranty; without even the implied 
% warranty of merchantability or fitness for a particular purpose. 
% See the GNU General Public License for more details 
% (enclosed in the file GPL).  
%
% Latest modifications: November 21, 2007, by Daniel Tamburrino


global DISPLAY
global filename
global FILTER_AMACRINE
global GLOBAL_KAPPA

% check that the image is a mosaic
if size(In,3)==1


    % new gaussian equivalent
    f = gaussFilter(FILTER_AMACRINE);

    % compute low-pass image
    x0=imfilter(In,f,'symmetric','same','conv')+mean(In(:))*GLOBAL_KAPPA;
  

    % optional display intermediary results
    if DISPLAY
        globalFac = mean(In(:))/2
        max_amacrine_image=max(x0(:))
        min_amacrine_image=min(x0(:))
        imwrite(x0/max(x0(:)),[filename '_amacrine' '.jpg'],'jpg');
    end

    % apply naka-rushton
    Out=(max(In(:))+x0).*In./(In+x0);
else
    error('Error in GanglionLocalNL, line 11: not a mosaic image');
end

% optional display intermediary results
if DISPLAY
    max_ganglion_image=max(Out(:))
    min_ganglion_image=min(Out(:))
    [H W P]=size(Out);
    I_disp = zeros(size(Out,1),size(Out,2),3);
    I_disp(1:2:H,1:2:W,1)=Out(1:2:H,1:2:W,1);
    I_disp(2:2:H,1:2:W,2)=Out(2:2:H,1:2:W,1);
    I_disp(1:2:H,2:2:W,2)=Out(1:2:H,2:2:W,1);
    I_disp(2:2:H,2:2:W,3)=Out(2:2:H,2:2:W,1);
    imwrite(I_disp,[filename '_ganglion.jpg']);
end