% This script runs estimations for 9370 colors in 10 different languages
% and compares the estimated LAB vaues against the English ground truth
% from the XKCD color survey. It prints out for each color the estimated
% values, the ground truth and the delta E distance. At the end it plots a
% histogram.
% 
% If you're using (parts of) this work, please cite the corresponding
% publication: ivrg.epfl.ch/Lindner_IEEE_MM_2015

% For any questions contact the author:
% ajl.epfl@gmail.com  http://ivrg.epfl.ch/people/lindner

load ground_truth.mat
Nc = length(ColorNames);
Nl = length(LanguageNames);

% get values of bin centers
[SRGB, LAB] = bincenters('lab_hist15_80');
N = 15;
LabL = reshape(LAB(:,1), [N N N]);
LabA = reshape(LAB(:,2), [N N N]);
LabB = reshape(LAB(:,3), [N N N]);

deltaE = zeros(Nc, Nl);

for c = 1:Nc
    cName = ColorNames{c};
    for l = 1:Nl
        language = LanguageNames{l};
        
        fname = ['./DB/lang_' language '/' cName '.mat'];
        load(fname);
        
        % find maximum bin and associated color values
        [A0, idx] = max(zvalues);
        bidx = floor((idx-1) / N^2);
        aidx = idx - bidx*N^2;
        aidx = floor((aidx-1) / N);
        Lidx = idx - bidx*N^2 - aidx*N;
        
        aidx = aidx + 1;
        bidx = bidx + 1;
        
        Lab_max = LAB(idx, :);
        RGB_max = SRGB(idx, :);
        
        dE = sqrt(sum((GT_LAB(c, :) - Lab_max).^2));
        deltaE(c, l) = dE;
        
        % print out values
        fprintf('\n%s, %s:\n', cName, language);
        fprintf('RGB = (%3d, %3d, %3d)   ', round(255*RGB_max(1)), round(255*RGB_max(2)), round(255*RGB_max(3)))
        fprintf('LAB = (%3d, %3d, %3d)\n', round(Lab_max(1)), round(Lab_max(2)), round(Lab_max(3)));
        
        fprintf('RGB = (%3d, %3d, %3d)   ', round(GT_RGB(1)), round(GT_RGB(2)), round(GT_RGB(3)))
        fprintf('LAB = (%3d, %3d, %3d)\n', round(GT_LAB(1)), round(GT_LAB(2)), round(GT_LAB(3)));
        
        fprintf('delta E = %.1f\n', dE);
        
    end
end

% plot histogram
close all
figure(1)
hold off
hist(deltaE(:), 30);
xlabel('delta E')
ylabel('frequency')
title(sprintf('%d color estimations in %d languages against English XKCD ground truth', Nc*Nl, Nl))
