function [withBP] = inferSaliency(hierarchy,pred,hh,ww)

for l = 1:length(hierarchy.whereat)
    
    temp = zeros(hh,ww);
    
    for k = 1:length(pred{l})
        
        temp(logical(sum(hierarchy.newPixels{1}(:,:,hierarchy.connections{l}{k}),3))) = pred{l}(k);
        
    end

end

numNodes = 0;

LC = [];

for i = 1:length(hierarchy.connections)
    
    val = length(hierarchy.connections{i});
    
    numNodes = numNodes + val;
    
    LC = [LC;repmat(i,val,1) (1:val)'];
    
end

adj     = sparse(numNodes,numNodes);

for i = 1:length(hierarchy.whereat) - 1
    
    for k = 1:length(hierarchy.whereat{i})
        
        id1 = find(LC(:,1) == i     & LC(:,2) == hierarchy.whereat{i}(k));
        
        id2 = find(LC(:,1) == i + 1 & LC(:,2) == hierarchy.whereat{i + 1}(k));
        
        adj(id1,id2) = 1;
        adj(id2,id1) = 1;
        
    end
    
end

nStates = 2;

edgeStruct = UGM_makeEdgeStruct(adj,nStates);

for e = 1:edgeStruct.nEdges
    
    n1 = LC(edgeStruct.edgeEnds(e,1),:);
    n2 = LC(edgeStruct.edgeEnds(e,2),:);
    
    s1 = pred{n1(1)}(n1(2));
    s2 = pred{n2(1)}(n2(2));
    
    pot_same = 0.0*(s1 - s2)^2 + 1;
    
    edgePot(:,:,e) = [pot_same  1;1 pot_same];
    
end

nodePot         = zeros(numNodes,2);

nodePot(:,1)    = 1*cell2mat(pred(:));

nodePot(:,2)    = 1;

[nodeBelTRBP1, ~, ~] = UGM_Infer_TRBP(nodePot,edgePot,edgeStruct);

withBP      = zeros(hh,ww);

ML = length(hierarchy.whereat{1});

withBPSP    = zeros(ML,1);


offset = 0;

for l = 1:length(hierarchy.whereat)
    
    withBPSP    = withBPSP + nodeBelTRBP1(offset + hierarchy.whereat{l},1);
    
    offset      = offset + length(hierarchy.connections{l});

end

for ll = 1:ML
    
    withBP(hierarchy.newPixels{1}(:,:,ll))      = withBPSP(ll);

end