function [hierarchy,edgeMap] = findSuperpixelChar(im,gt,numberOfSuperpixels,compactnessRatio)

global SS

[labels,meanColor,meanPos,pixels,colorHist,supHogs,edgeMagnitude,SPS,boundaryPixels,tp,fp,lab,averageSaliency]  = getSuperpixels(double(im),numberOfSuperpixels,compactnessRatio,gt);

ML = size(meanColor,1);

minmax = size(ML,4);

for k = 1:size(pixels,3)
    
    [y,x] = find(pixels(:,:,k));
    
    minmax(k,1) = min(x);
    minmax(k,2) = max(x);
    minmax(k,3) = min(y);
    minmax(k,4) = max(y);
    
end

% lab2 = imfilter(lab,fspecial('gaussian',3,2),'replicate');
% 
% L = lab2(:,:,1);
% A = lab2(:,:,2);
% B = lab2(:,:,3);
% 
% [DXL,DYL] = gradient(L);
% [DXA,DYA] = gradient(A);
% [DXB,DYB] = gradient(B);
% 
% edgeMagnitude = DXL.^2 + DYL.^2 + DXA.^2 + DYA.^2 + DXB.^2 + DYB.^2;

edgeMagnitude = edge(imfilter(rgb2gray(im),fspecial('gaussian',15,5),'replicate'),'canny');

edgeMap = imdilate(edgeMagnitude,strel('disk',3));

edgeMagnitude(1:SS,:) = 0;
edgeMagnitude(end-SS+1:end,:) = 0;
edgeMagnitude(:,1:SS) = 0;
edgeMagnitude(:,end-SS+1:end) = 0;

% sorted  = sort(edgeMagnitude(:),'descend');
% th      = sorted(round(numel(edgeMagnitude)/5));
% edgeMap = edgeMagnitude > th;

labels = labels + 1;

[neighbors,borderLength,edgeFit] = findNeighbors(labels,edgeMap);

hierarchy.newLabels{1}       = labels;
hierarchy.newMeanColor{1}    = meanColor;
hierarchy.newMeanPos{1}      = meanPos;
hierarchy.newNeighbors{1}    = neighbors;
hierarchy.newPixels{1}       = pixels;
hierarchy.newSPS{1}          = SPS';
hierarchy.newColorHist{1}    = colorHist;
hierarchy.newSupHogs{1}      = supHogs;
hierarchy.connections{1}     = num2cell(1:max(labels(:)));
hierarchy.whereat{1}         = 1:max(labels(:));
hierarchy.borderLength{1}    = borderLength;
hierarchy.edgeFit{1}         = edgeFit;
hierarchy.boundaryPixels{1}  = boundaryPixels;
hierarchy.truePositive{1}    = tp;
hierarchy.falsePositive{1}   = fp;
hierarchy.averageSaliency{1} = averageSaliency;
hierarchy.minmax{1}          = minmax;