function [neighborsOutput,borderLength,edgeFit] = findNeighbors(labels,edgeMap)

ML = max(labels(:));

neighbors       = cell(max(labels(:)),1);

edgeFit         = sparse(ML,ML);

onTheEdge       = false(ML,1);

imageBoundaryLength = zeros(ML,1);

for s = 1:size(labels,1)

    temp = labels(s,:);
    
    dd = [true diff(temp) ~= 0];
    
    temp        = temp(dd);
    
    onTheEdge(temp(1)) = true;
    onTheEdge(temp(end)) = true;
    
    imageBoundaryLength(temp(1)) = imageBoundaryLength(temp(1)) + 1;
    imageBoundaryLength(temp(end)) = imageBoundaryLength(temp(end)) + 1;
    
    edgeCount   = edgeMap(s,dd);
    
    for k = 1:length(temp)-1
        
        neighbors{temp(k)}      = ([neighbors{temp(k)} temp(k+1)]);
        neighbors{temp(k+1)}    = ([neighbors{temp(k+1)} temp(k)]);
        
        edgeFit(temp(k),temp(k+1)) = edgeFit(temp(k),temp(k+1)) + edgeCount(k+1);
        edgeFit(temp(k+1),temp(k)) = edgeFit(temp(k+1),temp(k)) + edgeCount(k+1);
        
    end
    
end

for s = 1:size(labels,2)

    temp = labels(:,s);
    
    dd = [true;diff(temp) ~= 0];
    
    temp = temp(dd);
    
    onTheEdge(temp(1)) = true;
    onTheEdge(temp(end)) = true;
    
    imageBoundaryLength(temp(1)) = imageBoundaryLength(temp(1)) + 1;
    imageBoundaryLength(temp(end)) = imageBoundaryLength(temp(end)) + 1;
    
    edgeCount   = edgeMap(dd,s);
    
    for k = 1:length(temp)-1
        
        neighbors{temp(k)}      = ([neighbors{temp(k)} temp(k+1)]);
        neighbors{temp(k+1)}    = ([neighbors{temp(k+1)} temp(k)]);
        
        edgeFit(temp(k),temp(k+1)) = edgeFit(temp(k),temp(k+1)) + edgeCount(k+1);
        edgeFit(temp(k+1),temp(k)) = edgeFit(temp(k+1),temp(k)) + edgeCount(k+1);
        
    end
    
end

borderLength    = sparse(ML,ML + 1);
neighborsOutput = logical(sparse(ML,ML));

for s = 1:length(neighbors)
    
    [temp,IA,IC]            = unique(neighbors{s});
    
    neighborsOutput(s,temp) = true;
    
    borderLength(s,temp)    = hist(IC,1:length(temp));
    
    if onTheEdge(s)
        
        borderLength(s,end) = imageBoundaryLength(s);
        
    end
    
end

% [hh,ww] = size(labels);
% 
% temp = zeros(hh,ww);
% 
% for k = 1:ML
%     
%     temp(labels == k) = sum(borderLength(k,:));
%     
% end
% 
% [DX DY] = gradient(labels);
% 
% edges = DX.^2+DY.^2 > 0 & edgeMap;
% 
% [yy xx] = find(edges);
% 
% subplot(1,2,1)
% imshow(temp,[])
% hold
% plot(xx,yy,'r.')
% hold
% subplot(1,2,2)
% imshow(labels,[])