function hierarchy = findHierarchy(hierarchy,level)

ML = size(hierarchy.newMeanColor{level},1);

if ML >= 3
    
    CD              = dist(hierarchy.newMeanColor{level},hierarchy.newMeanColor{level}');
    
    correspondence  = [];
    
    minVal = [];
    
    sorted = {};
    
    for s = 1:ML
        
        [mini index]        = min(CD(s,hierarchy.newNeighbors{level}(s,:)));
        
        [temp,sorted{s}]    = sort(CD(s,hierarchy.newNeighbors{level}(s,:)),'ascend');
        
        NN                  = find(hierarchy.newNeighbors{level}(s,:));
        
        sorted{s}           = NN(sorted{s});
        
        index               = NN(index);
        
        correspondence(s)   = index;
        
        minVal(s)           = mini;
        
    end
    
    count           = 1;
    
    allLabels       = 1:ML;
    
    processed       = false(ML,1);
    
%     tempNewLabels   = zeros(size(hierarchy.newLabels{level}));
    
    tempMeanColor   = [];
    
    tempNewPixels   = logical([]);
    
    tempNewSPS      = [];
    
    tempMeanPos     = [];
    
    tempColorHist   = [];
    
    tempSupHogs     = [];
    
    tempBoundaryPixels = [];
    
    tempTP = [];
    tempFP = [];
    
    check           = 1;
    
    for s = 1:ML
        
        if ~processed(s)
            
            if s - correspondence(correspondence(s)) == 0
                
                W1 = hierarchy.newSPS{level}(s);
                W2 = hierarchy.newSPS{level}(correspondence(s));
                
                hierarchy.connections{level + 1}{count} = [hierarchy.connections{level}{s} hierarchy.connections{level}{correspondence(s)}];
                
                hierarchy.whereat{level + 1}(hierarchy.whereat{level} == s) = count;
                hierarchy.whereat{level + 1}(hierarchy.whereat{level} == correspondence(s)) = count;
                
                hierarchy.minmax{level + 1}(count,1) = min(hierarchy.minmax{level}(s,1),hierarchy.minmax{level}(correspondence(s),1));
                hierarchy.minmax{level + 1}(count,2) = max(hierarchy.minmax{level}(s,2),hierarchy.minmax{level}(correspondence(s),2));
                hierarchy.minmax{level + 1}(count,3) = min(hierarchy.minmax{level}(s,3),hierarchy.minmax{level}(correspondence(s),3));
                hierarchy.minmax{level + 1}(count,4) = max(hierarchy.minmax{level}(s,4),hierarchy.minmax{level}(correspondence(s),4));
                
                hierarchy.averageSaliency{level + 1}(count,1) = hierarchy.averageSaliency{level}(s)...
                                                            + hierarchy.averageSaliency{level}(correspondence(s));
                
%                 tempNewLabels(hierarchy.newPixels{level}(:,:,s))                 = count;
%                 tempNewLabels(hierarchy.newPixels{level}(:,:,correspondence(s))) = count;
%                 
%                 tempNewPixels(:,:,count) = hierarchy.newPixels{level}(:,:,s) | hierarchy.newPixels{level}(:,:,correspondence(s));
                
                tempMeanColor(count,:) = (W1 * hierarchy.newMeanColor{level}(s,:)...
                    + W2 * hierarchy.newMeanColor{level}(correspondence(s),:)) ...
                    / (W1 + W2);
                
                tempMeanPos(count,:) = (W1 * hierarchy.newMeanPos{level}(s,:)...
                    + W2 * hierarchy.newMeanPos{level}(correspondence(s),:)) ...
                    / (W1 + W2);
                
                tempNewSPS(count) = W1 + W2;
                
                tempBoundaryPixels(count) = hierarchy.boundaryPixels{level}(s) + hierarchy.boundaryPixels{level}(correspondence(s));
                
                tempTP(count) = hierarchy.truePositive{level}(s) + hierarchy.truePositive{level}(correspondence(s));
                tempFP(count) = hierarchy.falsePositive{level}(s) + hierarchy.falsePositive{level}(correspondence(s));
                
                tempColorHist(count,:) = hierarchy.newColorHist{level}(s,:) + hierarchy.newColorHist{level}(correspondence(s),:);
                
                tempSupHogs(count,:) = hierarchy.newSupHogs{level}(s,:) + hierarchy.newSupHogs{level}(correspondence(s),:);
                
                processed(s) = true;
                processed(correspondence(s)) = true;
                
                count = count + 1;
                
                check = 0;
                
            else
                
                hierarchy.connections{level + 1}{count} = hierarchy.connections{level}{s};
                
                hierarchy.whereat{level + 1}(hierarchy.whereat{level} == s) = count;
                
                hierarchy.minmax{level + 1}(count,:) = hierarchy.minmax{level}(s,:);
                
                hierarchy.averageSaliency{level + 1}(count,1) = hierarchy.averageSaliency{level}(s);
                
%                 tempNewLabels(hierarchy.newPixels{level}(:,:,s)) = count;
%                 
%                 tempNewPixels(:,:,count) = hierarchy.newPixels{level}(:,:,s);
                
                tempMeanColor(count,:)      = hierarchy.newMeanColor{level}(s,:);
                
                tempMeanPos(count,:)        = hierarchy.newMeanPos{level}(s,:);
                
                tempNewSPS(count)           = hierarchy.newSPS{level}(s);
                
                tempBoundaryPixels(count)   = hierarchy.boundaryPixels{level}(s);
                
                tempTP(count)               = hierarchy.truePositive{level}(s);
                tempFP(count)               = hierarchy.falsePositive{level}(s);

                tempColorHist(count,:)      = hierarchy.newColorHist{level}(s,:);
                
                tempSupHogs(count,:)        = hierarchy.newSupHogs{level}(s,:);
                
                processed(s) = true;
                
                count = count + 1;
                
            end
            
        end
        
    end
    
%     tempNewLabels = hierarchy.whereat{level + 1}(hierarchy.newLabels{1});

    if check == 0
        
%         hierarchy.newLabels{level + 1}       = tempNewLabels;
        hierarchy.newMeanColor{level + 1}    = tempMeanColor;
        hierarchy.newMeanPos{level + 1}      = tempMeanPos;
        hierarchy.newSPS{level + 1}          = tempNewSPS;
        hierarchy.newColorHist{level + 1}    = tempColorHist;
        hierarchy.newSupHogs{level + 1}      = tempSupHogs;
        hierarchy.boundaryPixels{level + 1}  = tempBoundaryPixels;
        hierarchy.truePositive{level + 1}    = tempTP;
        hierarchy.falsePositive{level + 1}   = tempFP;
        
        ML = length(tempNewSPS);
        
        hierarchy.newNeighbors{level + 1} = logical(sparse(ML,ML));
        
        hierarchy.borderLength{level + 1} = sparse(ML,ML + 1);
        
        hierarchy.edgeFit{level + 1}      = sparse(ML,ML);

        for k = 1:length(hierarchy.newSPS{level + 1})
            
            oldMembers      = hierarchy.connections{level + 1}{k};

            [rr,cc]         = find(hierarchy.newNeighbors{1}(oldMembers,:));
            
            oldNeighbors    = setdiff(cc,oldMembers);

            tempNewMembers  = (hierarchy.whereat{level + 1}(oldNeighbors));
            
            newMembers      = unique(tempNewMembers);

            hierarchy.newNeighbors{level + 1}(k,newMembers) = true;
            
            newBorders      = full(sum(hierarchy.borderLength{1}(oldMembers,oldNeighbors),1));
            
            accumBorders    = accumarray(tempNewMembers',newBorders',[ML + 1 1],@sum,0,true)';
            
            hierarchy.borderLength{level + 1}(k,:) = accumBorders;
            
            hierarchy.borderLength{level + 1}(k,end) = sum(hierarchy.borderLength{1}(oldMembers,end));
            
            newEdgeFit      = full(sum(hierarchy.edgeFit{1}(oldMembers,oldNeighbors),1));
            
            accumEdgeFit    = accumarray(tempNewMembers',newEdgeFit',[ML 1],@sum,0,true)';
            
            hierarchy.edgeFit{level + 1}(k,:) = accumEdgeFit;
            
        end

        hierarchy = findHierarchy(hierarchy,level + 1);
        
    end
    
else

    return;
    
end