function [individualFeatures,individualPrecision] = extractFeatures(hierarchy)

[hh,ww] = size(hierarchy.newLabels{1});

global SS

individualFeatures  = {};
individualPrecision = {};

simpleFeatures = @(input)[mean(input) min(input) max(input) median(input)];

for level = 1:length(hierarchy.newMeanColor)
    
    ML = size(hierarchy.newMeanColor{level},1);

    totalEdge               = [];
    totalBorder             = [];

    CD = dist(hierarchy.newMeanColor{level},hierarchy.newMeanColor{level}');
    SD = dist(hierarchy.newSPS{level}',hierarchy.newSPS{level})/(hh*ww);
    
    HD = hierarchy.newColorHist{level}./repmat(sum(hierarchy.newColorHist{level},2),1,size(hierarchy.newColorHist{level},2));
    HD = dist(HD,HD');
     
    GD = hierarchy.newSupHogs{level}./repmat(sum(hierarchy.newSupHogs{level},2),1,size(hierarchy.newSupHogs{level},2));
    GD = dist(GD,GD');
    
    levelVectors    = [];
    levelPrecision  = [];

    relativeSize         = hierarchy.newSPS{level}/(hh*ww);

    arg = -CD/20;
    
    mxu = sum(repmat(hierarchy.newMeanPos{level}(:,1)',ML,1) .* exp(arg),2) ./ sum(exp(arg),2);
    myu = sum(repmat(hierarchy.newMeanPos{level}(:,2)',ML,1) .* exp(arg),2) ./ sum(exp(arg),2);
    
    vxu = sum(repmat((hierarchy.newMeanPos{level}(:,1)').^2,ML,1) .* exp(arg),2) ./ sum(exp(arg),2) - mxu.^2;
    vyu = sum(repmat((hierarchy.newMeanPos{level}(:,2)').^2,ML,1) .* exp(arg),2) ./ sum(exp(arg),2) - myu.^2;
    
    for l = 1:ML
        
        totalEdge(l)            = sum(hierarchy.edgeFit{level}(l,:)) / sum(hierarchy.borderLength{level}(l,:));

        totalBorder(l)          = hierarchy.boundaryPixels{level}(l) / hierarchy.newSPS{level}(l);
        
        localColorFeatures      = simpleFeatures(CD(l,hierarchy.newNeighbors{level}(l,:)));
        
        globalColorFeatures     = simpleFeatures(CD(l,[1:l-1 l+1:end]));
        
        localSizeFeatures       = simpleFeatures(SD(l,hierarchy.newNeighbors{level}(l,:)));
        
        globalSizeFeatures      = simpleFeatures(SD(l,[1:l-1 l+1:end]));
        
        localHistFeatures       = simpleFeatures(HD(l,hierarchy.newNeighbors{level}(l,:)));
        
        globalHistFeatures      = simpleFeatures(HD(l,[1:l-1 l+1:end]));
        
        localHogFeatures        = simpleFeatures(GD(l,hierarchy.newNeighbors{level}(l,:)));
        
        globalHogFeatures       = simpleFeatures(GD(l,[1:l-1 l+1:end]));
        
        spWidth                 = (hierarchy.minmax{level}(l,2) - hierarchy.minmax{level}(l,1) + 1) / ww;
        spHeight                = (hierarchy.minmax{level}(l,4) - hierarchy.minmax{level}(l,3) + 1) / hh;

        H                       = hierarchy.newColorHist{level}(l,:);
        H                       = H/sum(H);
        
        G                       = hierarchy.newSupHogs{level}(l,:);
        G                       = G/sum(G);
        
        histEntropy             = -sum(H.*log2(H+1e-6));
        hogEntropy              = -sum(G.*log2(G+1e-6));

        levelPrecision(l)       = hierarchy.truePositive{level}(l) / (hierarchy.truePositive{level}(l) + hierarchy.falsePositive{level}(l) + 1e-3);
        
        featureVector           = [...
            totalEdge(l)...
            totalBorder(l)...
            localColorFeatures...
            globalColorFeatures...
            localSizeFeatures...
            globalSizeFeatures...
            localHistFeatures...
            globalHistFeatures...
            localHogFeatures...
            globalHogFeatures...
            histEntropy...
            hogEntropy...
            relativeSize(l)...
            vxu(l)/ww^2 ...
            vyu(l)/hh^2 ...
            spWidth...
            spHeight...
            ];
        
        levelVectors(l,:) = featureVector;
        
    end
    
    individualFeatures{level}   = levelVectors;
    individualPrecision{level}  = levelPrecision';
    
end