function performance = calculateAUC(input,gt)

input = uint8(255*mat2gray(input));

if ~islogical(gt)
    
    gtBinary = gt > 128;
    
else
    
    gtBinary = gt;
    
end

tp = hist(input(gtBinary(:)),0:255);
fp = hist(input(~gtBinary(:)),0:255);

totalTP = sum(tp);

tp = fliplr(cumsum(fliplr(tp)));
fp = fliplr(cumsum(fliplr(fp)));

fn = totalTP - tp;

P = tp./(tp+fp+1e-3);
R = tp./(tp+fn+1e-3);

AUC = -sum(diff(R) .* (P(1:end-1) + P(2:end))/2);

AUC = AUC + R(end)*P(end);

performance.truePositives       = tp;
performance.falsePositives      = fp;
performance.falseNegatives      = fn;
performance.precision           = P;
performance.recall              = R;
performance.areaUnderCurve      = AUC;
performance.meanAbsoluteError   = mean(abs(im2double(input(:)) - im2double(gt(:))));
