function [im lh] = generateSample(letter,h,fontlist,i)

global frequency comb

[letter number] = conversion(letter,[],1);

if letter >= 65
    letterSet = find(rand <= frequency(number,:) ,1,'first');
end

cla(h)

imshow(ones(100));

text(50, 50, char(letter), 'fontname', fontlist{i}, 'fontsize', 28,...
    'horizontalalignment','left','verticalalignment','middle');

saveas(h,'test.png');
im = imread('test.png');
im = rgb2gray(im);
im = double(im);
im = im/max(im(:));

[rr cc] = find(im == 0);
lb = min(cc) - 1;
rb = max(cc) + 1;

tb = min(rr) - 1;
bb = max(rr) + 1;

letterImage = im(tb:bb,lb:rb);

cla(h)

if letter <= 57
    imshow(ones(100));
    text(50, 50, [char(letter)], 'fontname', fontlist{i}, 'fontsize', 28,...
        'horizontalalignment','left','verticalalignment','middle');
else
    imshow(ones(100));
    text(50, 50, [comb(letterSet,1) char(letter) comb(letterSet,2)], 'fontname', fontlist{i}, 'fontsize', 28,...
        'horizontalalignment','left','verticalalignment','middle');
end

saveas(h,'test.png');
im = imread('test.png');
im = rgb2gray(im);
im = double(im);
im = im/max(im(:));

res = normxcorr2(1-letterImage,1-im);

[maxi temp] = max(res(:));

[h w] = size(letterImage);

x = floor((temp - 1)/size(res,1)) + 1 - round(w/2);
y = mod(temp - 1, size(res,1)) + 1 - round(h/2);

d = max([round(h/2) round(w/2)]) + 5;

im = im(y + (-d:d),x + (-d:d));

lh = d;