function y = scaleImage(x, minI, maxI)
% scale an image between minI and maxI
% does not take the 3 channels separately
% USAGE y = scaleImage(x, minI, maxI)
% INPUT     x: image
%            minI : minumim after scaling
%            maxI : maximum after scaling
% OUTPUT    y : scaled image

%% -----------------------------------------------------------------------
% HDR CFA Image Rendering (Tone Mapping) 
% Written by David Alleysson and Laurence Meylan
% Copyright (C) 2007 Laboratory of Audiovisual Communications (LCAV), 
% Ecole Polytechnique Federale de Lausanne (EPFL), 
% CH-1015 Lausanne, Switzerland 
% 
% This program is free software; you can redistribute it and/or modify it 
% under the terms of the GNU General Public License as published by the 
% Free Software Foundation; either version 2 of the License, or (at your 
% option) any later version. This software is distributed in the hope that 
% it will be useful, but without any warranty; without even the implied 
% warranty of merchantability or fitness for a particular purpose. 
% See the GNU General Public License for more details 
% (enclosed in the file GPL). 
%
% Latest modifications: January 25, 2007, by Laurence Meylan


minX = min(x(:));
tmp = x - minX;

minTmp = min(tmp(:));
maxTmp = max(tmp(:));

if (maxTmp == 0)
    error('ERROR in scaleImage.m : divide by zero');
else
    y = (tmp*(maxI-minI)/maxTmp) + minI;
end
