function I2 = makeMosaic_hdr(hdr_file)
% function I2 = makeMosaic_hdr(hdr_file)
% read an HDR image and create the mosaic

%% -----------------------------------------------------------------------
% HDR CFA Image Rendering (Tone Mapping) 
% Written by David Alleysson and Laurence Meylan
% Copyright (C) 2007 Laboratory of Audiovisual Communications (LCAV), 
% Ecole Polytechnique Federale de Lausanne (EPFL), 
% CH-1015 Lausanne, Switzerland 
% 
% This program is free software; you can redistribute it and/or modify it 
% under the terms of the GNU General Public License as published by the 
% Free Software Foundation; either version 2 of the License, or (at your 
% option) any later version. This software is distributed in the hope that 
% it will be useful, but without any warranty; without even the implied 
% warranty of merchantability or fitness for a particular purpose. 
% See the GNU General Public License for more details 
% (enclosed in the file GPL). 
%
% Latest modifications: January 25, 2007, by Laurence Meylan


global DISPLAY;
global filename;

% function to read HDR images
% http://www.cis.rit.edu/mcsl/icam/hdr/read_rle_rgbe.m
I = read_rle_rgbe(hdr_file);

% normalize
I = I/max(I(:));

[H W P]=size(I);
I2 = zeros(size(I,1),size(I,2),1);
I2(1:2:H,1:2:W)=I(1:2:H,1:2:W,1);
I2(2:2:H,1:2:W)=I(2:2:H,1:2:W,2);
I2(1:2:H,2:2:W)=I(1:2:H,2:2:W,2);
I2(2:2:H,2:2:W)=I(2:2:H,2:2:W,3);