function newI = histoClip(I, tMin, tMax)
% USAGE: newI = histoClip(I, tMin, tMax)
% Apply a histogram clipping and scaline
% INPUT
%        I: input image, can be grayscale or color
%        tMin, tMax: percentage for histogram clipping
%        example: 0.01, 0.99
% OUTPUT
%        newI: image clipped and scaled in the range [0 1]

%% -----------------------------------------------------------------------
% HDR CFA Image Rendering (Tone Mapping) 
% Written by David Alleysson and Laurence Meylan
% Copyright (C) 2007 Laboratory of Audiovisual Communications (LCAV), 
% Ecole Polytechnique Federale de Lausanne (EPFL), 
% CH-1015 Lausanne, Switzerland 
% 
% This program is free software; you can redistribute it and/or modify it 
% under the terms of the GNU General Public License as published by the 
% Free Software Foundation; either version 2 of the License, or (at your 
% option) any later version. This software is distributed in the hope that 
% it will be useful, but without any warranty; without even the implied 
% warranty of merchantability or fitness for a particular purpose. 
% See the GNU General Public License for more details 
% (enclosed in the file GPL). 
%
% Latest modifications: January 25, 2007, by Laurence Meylan


% trick to make stretchlim work correctly
I = I/max(I(:));
% find low and high values
low_high = stretchlim(I, [tMin tMax]);
newMax = max(low_high(2,:));
newMin = min(low_high(1,:));

% clip and scale
newI = scaleImage(min(max(I,newMin),newMax),0,1);  

