function G = gaussFilter(sigma)
% function G = gaussFilter(sigma)
% create a 2d gaussian filter of spatial constant sigma
% the support is 3 times sigma

%% -----------------------------------------------------------------------
% HDR CFA Image Rendering (Tone Mapping) 
% Written by David Alleysson and Laurence Meylan
% Copyright (C) 2007 Laboratory of Audiovisual Communications (LCAV), 
% Ecole Polytechnique Federale de Lausanne (EPFL), 
% CH-1015 Lausanne, Switzerland 
% 
% This program is free software; you can redistribute it and/or modify it 
% under the terms of the GNU General Public License as published by the 
% Free Software Foundation; either version 2 of the License, or (at your 
% option) any later version. This software is distributed in the hope that 
% it will be useful, but without any warranty; without even the implied 
% warranty of merchantability or fitness for a particular purpose. 
% See the GNU General Public License for more details 
% (enclosed in the file GPL). 
%
% Latest modifications: January 25, 2007, by Laurence Meylan


x = -(floor(sigma*3)):floor((sigma*3));
y = gaussmf(x,[sigma 0]);
G = conv2(y,y');
G = G/sum(G(:));