function Out=InterpChr(In)
% function Out=InterpChr(In)
% frequency selection demosaicing
% chrominance interpolation

%% -----------------------------------------------------------------------
% HDR CFA Image Rendering (Tone Mapping) 
% Written by David Alleysson and Laurence Meylan
% Copyright (C) 2007 Laboratory of Audiovisual Communications (LCAV), 
% Ecole Polytechnique Federale de Lausanne (EPFL), 
% CH-1015 Lausanne, Switzerland 
% 
% This program is free software; you can redistribute it and/or modify it 
% under the terms of the GNU General Public License as published by the 
% Free Software Foundation; either version 2 of the License, or (at your 
% option) any later version. This software is distributed in the hope that 
% it will be useful, but without any warranty; without even the implied 
% warranty of merchantability or fitness for a particular purpose. 
% See the GNU General Public License for more details 
% (enclosed in the file GPL). 
%
% Latest modifications: January 25, 2007, by Laurence Meylan


[H W]=size(In);

% modulation
C1(1:2:H,1:2:W,1)=In(1:2:H,1:2:W);
C1(2:2:H,1:2:W,2)=In(2:2:H,1:2:W);
C1(1:2:H,2:2:W,2)=In(1:2:H,2:2:W);
C1(2:2:H,2:2:W,3)=In(2:2:H,2:2:W);

% interpolation
C1(:,:,1)=conv2(C1(:,:,1),[1 2 1;2 4 2;1 2 1]/4,'same');
C1(:,:,2)=conv2(C1(:,:,2),[0 1 0;1 4 1;0 1 0]/4,'same');
C1(:,:,3)=conv2(C1(:,:,3),[1 2 1;2 4 2;1 2 1]/4,'same');

Out=reshape([C1(:,:,1) C1(:,:,2) C1(:,:,3)],H,W,3);

