function [Lum, Chr]=GetLumChr(In)
% function [Lum, Chr]=GetLumChr(In)
% luminance frequency selection for demosaicing
% In: Mosaic image
% OUTPUT: Lum: luminance 
%         Chr: chrominance

%% -----------------------------------------------------------------------
% HDR CFA Image Rendering (Tone Mapping) 
% Written by David Alleysson and Laurence Meylan
% Copyright (C) 2007 Laboratory of Audiovisual Communications (LCAV), 
% Ecole Polytechnique Federale de Lausanne (EPFL), 
% CH-1015 Lausanne, Switzerland 
% 
% This program is free software; you can redistribute it and/or modify it 
% under the terms of the GNU General Public License as published by the 
% Free Software Foundation; either version 2 of the License, or (at your 
% option) any later version. This software is distributed in the hope that 
% it will be useful, but without any warranty; without even the implied 
% warranty of merchantability or fitness for a particular purpose. 
% See the GNU General Public License for more details 
% (enclosed in the file GPL). 
%
% Latest modifications: January 25, 2007, by Laurence Meylan


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% possible filter to use:
% filtrage de luminance
% f=     [ 0  0  0  0  1  0  1  0  0  0  0
%          0  0  0 -1  0 -2  0 -1  0  0  0
%          0  0  1  1  2  1  2  1  1  0  0
%          0 -1  1 -5  3 -9  3 -5  1 -1  0
%          1  0  2  3  1  7  1  3  2  0  1
%          0 -2  1 -9  7 104 7 -9  1 -2  0
%          1  0  2  3  1  7  1  3  2  0  1
%          0 -1  1 -5  3 -9  3 -5  1 -1  0
%          0  0  1  1  2  1  2  1  1  0  0
%          0  0  0 -1  0 -2  0 -1  0  0  0
%          0  0  0  0  1  0  1  0  0  0  0]/128;

% f= [-2  3  -6  3  -2;
%      3  4   2  4   3;
%     -6  2  48  2  -6;
%      3  4   2  4   3;
%     -2  3  -6  3  -6]/64;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% our filter
f=[1 2 1;2 4 2;1 2 1]/16;
f=conv2(f,f);

% the luminance is directly extracted from the mosaic image
Lum=conv2(In,f,'same');

% the chrominance is extracted by using a high pass filter
f=conv2(f,f);
f=conv2(f,[1 2 1;2 4 2;1 2 1]/16);
dirac=zeros(11,11);dirac(6,6)=1;
Chr=conv2(In,dirac-f,'same');
