/**
 * \class SaveRectangle
 *
 *
 * \brief Saves all the rectangles information in the text file.
 *
 * When the user presses the "Save" button, this class will save all the information in the related text file.
 *
 * \note The following information is saved: ID,Top-left x coordinate,Top-Left y coordinate,Width,Height,Annotation
 * ,Word number,Line number.
 *
 * \author $Author: David Carmona-Moreno $
 *
 * \version $Revision: 1.0 $
 *
 * \date $Date: 2016/01/11 14:00:00 $
 * \bug Not known bugs.
 *
 * Contacts: nikolaos.arvanitopoulos@epfl.ch and david.carmona-moreno@epfl.ch
 *
 * Created on: Mon Jan 12 14:00:00 2016
 *
 */

#ifndef SAVERECTANGLE
#define SAVERECTANGLE

#include "imagegraphicsscene.h"
#include"filewritterxml.h"

#include <QList>
#include <QDebug>

#include "rectangledraw.h"

class SaveRectangle{

private:

    // The application scene where all the rectangles are drawn
    ImageGraphicsScene *scene;

    // The list containing all the rectangles drawn in the scene
    QList <RectangleDraw*> list;

public:

    /** @brief The constructor of the SaveRectangle class
     *  @param scene_1 The application scene
     */
    SaveRectangle(ImageGraphicsScene *scene_1):scene(scene_1)
    {
    }

    /** @brief Sets the application scene
     *  @param graphics_scene The application scene
     *  @return void
     */
    virtual void setScene(ImageGraphicsScene *graphics_scene);

    /** @brief Saves all the changes made by the user
     *  @return void
     */
    virtual void saveChanges(QString extension);

    /** @brief Bug. Do not use it
     */
    virtual void saveAs(CreateFileAbstraction *cfa,FileWriter *fw);
};

#endif // SAVERECTANGLE

