#include "saverectangle.h"

void SaveRectangle::setScene(ImageGraphicsScene *graphics_scene){
    this->scene=graphics_scene;
}

void SaveRectangle::saveAs(CreateFileAbstraction *cfa, FileWriter *fw){

    this->scene->setFileWriter(fw);
    this->scene->setCreateFileAbstraction(cfa);

    // Open the file
    this->scene->getFileWriter()->getCreateFileAbstraction()->getFile()->open(QIODevice::ReadWrite | QIODevice::Truncate | QIODevice::Text);

    // Get all the rectangles contained in the QGraphicsScene
    this->list=scene->getList();

    // Write the image path in the file
    this->scene->getFileWriter()->writeImageName(scene->getCreateFileAbstraction()->getImage()->getImageFilePath());

    int j=0;

    while(j!=(this->list.size())){

     // Each element of the list is a rectangle
     RectangleDraw* buf=list.at(j);

     // Write in the file the rectangle id
     this->scene->getFileWriter()->writeFileRectangleId(buf->getId());

     // Write in the file the top-lef point coordinates
     this->scene->getFileWriter()->writeFilePoint(buf->getPoint().x(),buf->getPoint().y());

     // Write in the file the width and the height
     this->scene->getFileWriter()->writeFileRectangleGeo(buf->rect().width(),buf->rect().height());

     // Write the word number
     this->scene->getFileWriter()->writeWordNumber(buf->getWordNumber());

     // Write the line number
     this->scene->getFileWriter()->writeLineNumber(buf->getLineNumber());

     // Write the annotation
     this->scene->getFileWriter()->writeComment(buf->getAnnotation());

     // Change line each time we select a new rectangle
     this->scene->getFileWriter()->changeLine();

     j=j+1;
    }

    // Close the file
    this->scene->getFileWriter()->getCreateFileAbstraction()->getFile()->close();

    j=0;
}

void SaveRectangle::saveChanges(QString extension){


    if(!extension.compare("txt")){


    // Open the file
    this->scene->getFileWriter()->getCreateFileAbstraction()->getFile()->open(QIODevice::ReadWrite | QIODevice::Truncate | QIODevice::Text);

    // Get all the rectangles contained in the QGraphicsScene
    this->list=scene->getList();

    // Write the image path in the file
    this->scene->getFileWriter()->writeImageName(scene->getCreateFileAbstraction()->getImage()->getImageFilePath());

    int j=0;

    while(j!=(this->list.size())){

     // Each element of the list is a rectangle
     RectangleDraw* buf=list.at(j);

     // Write in the file the rectangle id
     this->scene->getFileWriter()->writeFileRectangleId(buf->getId());

     // Write in the file the top-lef point coordinates
     this->scene->getFileWriter()->writeFilePoint(buf->rect().topLeft().x(),buf->rect().topLeft().y());

     // Write in the file the width and the height
     this->scene->getFileWriter()->writeFileRectangleGeo(buf->rect().width(),buf->rect().height());

     // Write the word number
     this->scene->getFileWriter()->writeWordNumber(buf->getWordNumber());

     // Write the line number
     this->scene->getFileWriter()->writeLineNumber(buf->getLineNumber());

     // Write the annotation
     this->scene->getFileWriter()->writeComment(buf->getAnnotation());

     // Change line each time we select a new rectangle
     this->scene->getFileWriter()->changeLine();

     j=j+1;
    }

    // Close the file
    this->scene->getFileWriter()->getCreateFileAbstraction()->getFile()->close();

    j=0;
    }

    else{ //write .xml file
        QString imageName = scene->getCreateFileAbstraction()->getImage()->getImageFilePath();
        FileWritterXML file =  FileWritterXML(imageName,scene->getList());
    }
}


