/**
 * \class RemoveConfirmationWindow
 *
 *
 * \brief The window asking for the user confirmation when he wants to delete a rectangle.
 *
 * The RectangleWindow class implements the different graphical elements descrbing the confirmatio window/
 *
 * \author David Carmona-Moreno
 *
 * \version  1.0
 *
 * \date 2016/01/11 14:00:00
 * \bug Not known bugs.
 *
 * Contacts: nikolaos.arvanitopoulos@epfl.ch and david.carmona-moreno@epfl.ch
 *
 * Created on: Mon Jan 12 14:00:00 2016
 *
 */

#ifndef REMOVEICONPICTURE
#define REMOVEICONPICTURE

#include <QGraphicsScene>
#include <QWidget>
#include <QtextEdit>
#include <QLineEdit>
#include <QVBoxLayout>
#include <QPushButton>
#include <QObject>
#include <QLabel>

#include "rectangledraw.h"

class RemoveConfirmationWindow:public QWidget{
    Q_OBJECT

private:

    // The rectangle which is going to be deleted
    RectangleDraw *rectangleDraw;

    // The application scene where the rectangle is drawn
    QGraphicsScene *graphicScene;

    // The list containing all the rectangles drawn in the scene
    QList<RectangleDraw*> *list;

    // Create a push button
    QPushButton* push_delete;

    // Create a push button
    QPushButton* push_noDelete;

    // Create a horizontal layout containing the push button
    QHBoxLayout *push_layout;

    // Create a vertical layout
    QVBoxLayout* layout;

    // Create the label which is going to display the
    QLabel *text;

public:

    /** @brief The constructor of the RemoveConfirmationWindow class
     *  @param rectangle The rectangle that the uer wants to remove
     *  @param scene The application scene
     *  @param list_1 The list of the rectangles drawn in the scene
     */
    RemoveConfirmationWindow(RectangleDraw *rectangle,QGraphicsScene *scene,QList<RectangleDraw*> *list_1):rectangleDraw(rectangle),
        graphicScene(scene),list(list_1)
    {
        text=new QLabel(this);
        text->setText("Do you really want to delete rectangle number "+QString::number(rectangleDraw->getId())+" ?");

        push_delete=new QPushButton();
        push_delete->setText("Delete the rectangle");
        push_noDelete=new QPushButton();
        push_noDelete->setText("Do not delete the rectangle");

        layout=new QVBoxLayout(this);
        push_layout=new QHBoxLayout();

        push_layout->addWidget(push_delete);
        push_layout->addWidget(push_noDelete);

        layout->addWidget(text);
        layout->addLayout(push_layout);

        this->setWindowTitle("Delete Rectangle "+QString::number(rectangle->getId()));
        this->show();

        QObject::connect(push_delete,SIGNAL(clicked()),this,SLOT(push_delete_Clicked()));
        QObject::connect(push_noDelete,SIGNAL(clicked()),this,SLOT(push_noDelete_Clicked()));

    }

private slots:

    /** @brief User presses the "delete rectangle" button
     *  @return Void.
     */
    void push_delete_Clicked();

    /** @brief User presser the "do not delete rectangle" button
     *  @return Void.
     */
    void push_noDelete_Clicked();
};

#endif // REMOVEICONPICTURE

