/**
 * \class RectangleWindow
 *
 *
 * \brief The annotation window.
 *
 * The RectangleWindow class implements the different graphical elements descrbing the annotation window.
 *
 * \note The following fiels should be field by the user: Line Number,Word Number and Comments. The rectangle ID
 * is automatically computed by the application.
 *
 * \author David Carmona-Moreno
 *
 * \version  1.0
 *
 * \date 2016/01/11 14:00:00
 * \bug Not known bugs.
 *
 * Contacts: nikolaos.arvanitopoulos@epfl.ch and david.carmona-moreno@epfl.ch
 *
 * Created on: Mon Jan 12 14:00:00 2016
 *
 */

#ifndef RECTANGLEWINDOW
#define RECTANGLEWINDOW

#include <QtextEdit>
#include <QLineEdit>
#include <QVBoxLayout>
#include <QPushButton>
#include <QObject>
#include <QLabel>

#include <QWidget>
#include "rectangledraw.h"
#include <QDebug>
#include "filewriter.h"
#include "addiconpicture.h"
#include "filereader.h"

class RectangleWindow:public QWidget {

    Q_OBJECT

private:

    // The rectangle associated to the dialog window
    RectangleDraw *rectangle;

    // Create the annotation space
    QTextEdit* textEdit;

    // Create the space where the user can insert the word number
    QLineEdit *lineEdit_word;

    // Create the space where the user can insert the line number
    QLineEdit *lineEdit_line;

    // Create a vertical layout
    QVBoxLayout* layout;

    // Create a horizontal layout containing the rectangle id
    QHBoxLayout *id_layout;

    // Create a horizontal layout containing the line insertion
    QHBoxLayout *line_layout;

    // Create a horizontal layout containing the word insertion
    QHBoxLayout *word_layout;

    // Create a horizontal layout containg the annotation insertion
    QHBoxLayout *annotation_layout;

    // Create a horizontal layout containing the push button
    QHBoxLayout *push_layout;

    // Create a push button
    QPushButton* push;

    // Create the label which is going to display the rectangle id
    QLabel *id_label_show;

    // Create the label displaying the text "Id:"
    QLabel *id_text;

    // Create the label displaying the text "Line:"
    QLabel *line_label;

    // Create the label displaying the text "Word:"
    QLabel *word_label;

    // Create the lable displaying the text "Annotation:"
    QLabel *annotation_label;

    // The icon picture
    AddIconPicture *icon;

    // The scene
    QGraphicsScene *scene;

    QString str;

    // The file writer
    FileWriter *filewriter;


public:

    /** @brief The constructor of the RectangleWindow class
     *  @param rectangle_1 The rectangle selected by the user for annotation_label
     *  @param filewriter_1 The FileWriter used to write the annotations in a text file
     *  @param scene_1 The application scene
     */
    RectangleWindow(RectangleDraw* rectangle_1,FileWriter *filewriter_1,QGraphicsScene *scene_1):rectangle(rectangle_1),
    filewriter(filewriter_1),scene(scene_1)
    {
        textEdit=new QTextEdit();
        textEdit->setMaximumSize(100,50);
        textEdit->setText(rectangle->getAnnotation());
        lineEdit_word=new QLineEdit();
        lineEdit_line=new QLineEdit();
        lineEdit_word->setMaximumSize(100,20);
        lineEdit_word->setText(rectangle->getWordNumber());

        lineEdit_line->setMaximumSize(100,20);
        lineEdit_line->setText(rectangle->getLineNumber());

        line_label=new QLabel(this);
        line_label->setText("Line Number:");
        word_label=new QLabel(this);
        word_label->setText("Word Number:");

        id_label_show=new QLabel(this);
        id_label_show->setAlignment(Qt::AlignLeft);
        id_text=new QLabel(this);
        id_text->setText("Id:");

        annotation_label=new QLabel();
        annotation_label->setText("Comments:");

        push=new QPushButton();
        push->setText("Add Note");

        layout=new QVBoxLayout(this);
        id_layout=new QHBoxLayout();
        line_layout=new QHBoxLayout();
        word_layout=new QHBoxLayout();
        annotation_layout=new QHBoxLayout();
        push_layout=new QHBoxLayout();

        id_label_show->setNum(rectangle->getId());

        id_layout->addWidget(id_text);
        id_layout->addWidget(id_label_show);
        line_layout->addWidget(line_label);
        line_layout->addWidget(lineEdit_line);
        word_layout->addWidget(word_label);
        word_layout->addWidget(lineEdit_word);
        annotation_layout->addWidget(annotation_label);
        annotation_layout->addWidget(textEdit);
        push_layout->addWidget(push);

        layout->addLayout(id_layout);
        layout->addLayout(line_layout);
        layout->addLayout(word_layout);
        layout->addLayout(annotation_layout);
        layout->addLayout(push_layout);

        this->setWindowTitle("Rectangle "+QString::number(rectangle->getId()));
        this->show();

        QObject::connect(textEdit,SIGNAL(textChanged()),this,SLOT(textChangedSlot()));
        QObject::connect(lineEdit_word,SIGNAL(textChanged(QString)),this,SLOT(wordChangedSlot(QString)));
        QObject::connect(lineEdit_line,SIGNAL(textChanged(QString)),this,SLOT(lineChangedSlot(QString)));
        QObject::connect(push,SIGNAL(clicked()),this, SLOT(quit()));
    }

private slots:

    /** @brief The "Quit Window" event
     *  @return Void.
     */
    void quit();

    /** @brief TextChanged event
     *  @return Void.
     */
    void textChangedSlot();

    /** @brief WordChanged event
     *  @return Void.
     */
    void wordChangedSlot(QString word);

    /** @brief The LineChanged event
     *  @return Void.
     */
    void lineChangedSlot(QString line);
};

#endif // RECTANGLEWINDOW

