/**
 * \class RectangleDraw
 *
 *
 * \brief Describes a rectangle drawn by the user.
 *
 * The RectangleDraw class implements the different graphical and mathematical elements that describe a rectangle drawn by the user.
 *
 * \author David Carmona-Moreno
 *
 * \version  1.0
 *
 * \date 2016/01/11 14:00:00
 * \bug Not known bugs.
 *
 * Contacts: nikolaos.arvanitopoulos@epfl.ch and david.carmona-moreno@epfl.ch
 *
 * Created on: Mon Jan 12 14:00:00 2016
 *
 */

#ifndef RECTANGLEDRAW
#define RECTANGLEDRAW

#include <QGraphicsRectItem>
#include <QPointF>
#include <QGraphicsPixmapItem>
#include <QDebug>
#include <QGraphicsSceneMouseEvent>
#include <QGraphicsSceneHoverEvent>
#include <QGraphicsSceneDragDropEvent>
#include <QGraphicsItem>

class RectangleDraw:public QGraphicsRectItem{

private:

    // The rectangle id
    int id;

    // Top-Left point coordinates
    QPointF point;

    // The line number
    QString lineNumber;

    // The word number in the line
    QString wordNumber;

    // Create the annotation
    QString annotation;

    // The annotation icon
    QGraphicsPixmapItem *item;

    // The top-right point
    QPointF topRight;

    // The bottom-right point
    QPointF bottomRight;

    // The bottom-left point
    QPointF bottomLeft;

    // Get the QRectF object
    QRectF rectF;

    // The width of the rectangle
    int width;

    // The height of the rectangle
    int height;

    // Checks if the user wants to delete really one rectangle
    bool checkDelete;

public:

    /** @brief The constructor of the RectangleDraw class
     */
    RectangleDraw():id(0),point(0,0),item(NULL),topRight(0,0),bottomRight(0,0),bottomLeft(0,0),rectF(0,0,0,0),
        height(0),width(0),annotation("Insert your annotation"),wordNumber("0"),lineNumber("0"),checkDelete(false)
    {
       //this->setFlag(QGraphicsItem::ItemIsSelectable,false);
       this->setFlag(QGraphicsItem::ItemSendsGeometryChanges,false);
    }

    /** @brief Returns the rectangle ID
     *  @return The rectangle ID
     */
    virtual int getId() const;

    /** @brief Sets the rectangle id
     *  @param id The rectangle id
     */
    virtual void setId(int id);

    /** @brief Returns the Top-Left point coordinates
     *  @return The Top-Left point coordinates
     */
    virtual QPointF getPoint()const;

    /** @brief Sets the Top-Left point coordinates
     *  @param point The Top-Left point coordinates
     */
    virtual void setPoint(QPointF point);

    /** @brief Returns the line number inserted by the user
     *  @return The line number
     */
    virtual QString getLineNumber() const;

    /** @brief Sets the line number inserted by the user
     *  @param lineNumber The line number inserted by the user
     */
    virtual void setLineNumber(QString lineNumber);

    /** @brief Sets the word number inserted by the user
     *  @param word The word number inserted by the user
     */
    virtual void setWordNumber(QString word);

    /** @brief Returns the word number inserted by the user
     *  @return The word number
     */
    virtual QString getWordNumber() const;

    /** @brief Returns the comment inserted by the user
     *  @return The comment
     */
    virtual QString getAnnotation() const;

    /** @brief Returns Top-Right point coordinates
     *  @return The Top-Right point coordinates
     */
    virtual QPointF getTopRight();

    /** @brief Sets the Top-Right point coordinates
     *  @param point The Top-Right point coordinates
     */
    virtual void setTopRight(QPointF point);

    /** @brief Returns the Bottom-Right point coordinates
     *  @return The Bottom-Right point coordinates
     */
    virtual QPointF getBottomRight();

    /** @brief Sets Bottom-Right point coordinates
     *  @param point The Bottom-Right point coordinates
     */
    virtual void setBottomRight(QPointF point);

    /** @brief Returns the Bottom-Left point coordianates
     *  @return The Bottom-Left point coordinates
     */
    virtual QPointF getBottomLeft();

    /** @brief Sets the Bottom-Left point coordinates
     *  @param point The Bottom-Left point coordinates
     */
    virtual void setBottomLeft(QPointF point);

    /** @brief Sets the comment inserted by the user
     *  @param annotation The comment
     */
    virtual void setAnnotation(QString annotation);

    /** @brief Returns the little icon which indicates if the rectangle has been annotated or not
     *  @return The little icon
     */
    virtual QGraphicsPixmapItem* getItem()const;

    /** @brief Sets the little icon which indicats if the user has annotatted the rectangle
     *  @param item The item
     */
    virtual void setItem(QGraphicsPixmapItem *item);

    /** @brief Deprecated method. Will be remove in a future release
     */
    virtual void adjustSize(int x, int y);

    /** @brief Sets the rectangle coordinates
     *  @param rect The rectangle coordinates
     */
    virtual void setRectF(QRectF rect);

    /** @brief Returns the rectangle coordinates
     *  @return The rectangle coordinates
     */
    virtual QRectF getRectF()const;

     /** @brief Sets the state of the variable checking if the user wants to delete the rectangel
     *  @param checkDelete_1 The state of the variable (true or false)
     */
    virtual void setCheckDelete(bool checkDelete_1);

    /** @brief Check if the user wants to delete the rectangle or not
     *  @return True if the user wants to delete the rectangle and false if not
     */
    virtual bool getCheckDelete()const;
};

#endif // RECTANGLEDRAW

