#include "rectangledraw.h"
#include <qDebug>

// Return Id
int RectangleDraw::getId()const{
    return id;
}

// Modify id
void RectangleDraw::setId(int id){
    this->id=id;
}

// Return top-left point
QPointF RectangleDraw::getPoint() const{
    return point;
}

// Set the top-left point
 void RectangleDraw::setPoint(QPointF point){
     this->point=point;

 }

 // Get the line number
QString RectangleDraw::getLineNumber() const{
    return lineNumber;
}

 // Set the line number
void RectangleDraw::setLineNumber(QString lineNumber){
    this->lineNumber=lineNumber;
}

// Get the annotation
QString RectangleDraw::getAnnotation() const{
    return annotation;
}

// Set the annotation
void RectangleDraw::setAnnotation(QString annotation){
    this->annotation=annotation;
}

// Set the word number
void RectangleDraw::setWordNumber(QString word){
    this->wordNumber=word;
}

// Get the word number
QString RectangleDraw::getWordNumber() const{
    return wordNumber;
}

// Get the annotation item
QGraphicsPixmapItem *RectangleDraw::getItem()const{
    return item;
}

// Set the annotaiton item
void RectangleDraw::setItem(QGraphicsPixmapItem* item){
    this->item=item;
}

// Get the top-right point
QPointF RectangleDraw::getTopRight(){

    QPointF point_buffer(this->rect().width(),0);
    this->topRight=this->point+point_buffer;

    return topRight;
}

// Set the top-right point
void RectangleDraw::setTopRight(QPointF point){
    this->topRight=point;
}

// Get the bottom-right point
QPointF RectangleDraw::getBottomRight(){

    QPointF point_buffer(0,this->rect().height());
    QPointF point_buffer1(this->rect().width(),0);
    this->bottomRight=this->point+point_buffer1+point_buffer;

    return bottomRight;
}

// Set the bottom-right point
void RectangleDraw::setBottomRight(QPointF point){
    this->bottomRight=point;
}

// Get the bottom-left point
QPointF RectangleDraw::getBottomLeft(){

    QPointF point_buffer(0,this->rect().height());
    this->bottomLeft=this->point+point_buffer;

    return bottomLeft;
}

// Set the bottom-left point
void RectangleDraw::setBottomLeft(QPointF point){
    this->bottomLeft=point;
}

// Adjust the size of the rectangle according to the user input
void RectangleDraw::adjustSize(int x, int y){
    width += x;
    height += y;
}

// Set the QRectF object
void RectangleDraw::setRectF(QRectF rect){
    this->rectF=rect;
}

// Get the QRectF object
QRectF RectangleDraw::getRectF()const{
    return rectF;
}

// Set the checkDelete variable
void RectangleDraw::setCheckDelete(bool checkDelete_1){
    this->checkDelete=checkDelete_1;
}

// Get the state of the checkDelete variable
bool RectangleDraw::getCheckDelete()const{
    return this->checkDelete;
}

