/**
 * \class ImageViewer
 *
 *
 * \brief Main window of the application.
 *
 * This class is the main window of the entire application. It contains all the graphical elemnts that the user will
 * need in order to load,display and annotate the elected image.
 *
 *
 * \author $Author: David Carmona-Moreno $
 *
 * \version $Revision: 1.0 $
 *
 * \date $Date: 2016/01/11 14:00:00 $
 * \bug Not known bugs.
 *
 * Contacts: nikolaos.arvanitopoulos@epfl.ch and david.carmona-moreno@epfl.ch
 *
 * Created on: Mon Jan 12 14:00:00 2016
 *
 */

#ifndef IMAGEVIEWER
#define IMAGEVIEWER

#include <QMainWindow>
#include <QMenu>
#include <QAction>
#include <QtWidgets>

#include "image.h"
#include "createfileabstraction.h"
#include "actionbutton.h"

class ImageViewer:public QMainWindow{

    Q_OBJECT

private:

    // The image we want to load and display
    Image *image;

    // The file creator class aimed to create a file related to the image
    CreateFileAbstraction *file;

    // Create the file Menu in the Menu bar
    QMenu *fileMenu;

    // Open an image action
    QAction *openAct;

    // The SaveAs action
    QAction *saveAs;

    // Open the image file
    ActionButton *userAction;

    // Add the draw toolBar
    QToolBar *menuToolBar;

public:

    /** @brief The constructor of the ImageViewer class
     *  @param parent The ImageViewer has no parent widget
     */
    ImageViewer(QWidget *parent=0);

    /** @brief Class destructor
     */
    virtual ~ImageViewer(){};

    /** @brief Creates the menu bar
     *  @return void
     */
    virtual void createMenus();

    /** @brief Creates all the actions related to the icons
     *  @return void
     */
    virtual void createActions();
};

#endif // IMAGEVIEWER
