#include "imageviewer.h"

#include <iostream>
using namespace std;

ImageViewer::ImageViewer(QWidget *parent):QMainWindow(parent)
{
    // Set the main window title.
    setWindowTitle(tr("Ground_Truthing GUI"));

    this->showMaximized();

    this->createMenus();
    this-> createActions();
}

void ImageViewer::createMenus()
{
    // Create and display the file menu
    fileMenu=new QMenu(tr("&File"), this);
    this->menuBar()->addMenu(fileMenu);

    // Add the toolbar to the main window
    menuToolBar=this->addToolBar("main toolbar");
}

void ImageViewer::createActions()
{
    // The seven icons in the toolbar
    QPixmap save("../Icons/save.png");
    QPixmap xml("../Icons/xml.png");
    QPixmap draw("../Icons/draw_rectangle.png");
    QPixmap erase("../Icons/history_eraser_icon.png");
    QPixmap drag("../Icons/cursor_hand.png");
    QPixmap zoom_in("../Icons/zoom_in.png");
    QPixmap zoom_out("../Icons/zoom_out.png");
    QPixmap modify("../Icons/pencil.png");
    QPixmap arrow("../Icons/cursor-arrow.png");

    // Object: "Open an image"
    // The openAct object contains a signal named "triggered"
    openAct = new QAction(tr("&Open..."), this);

    // The saveAs menu
    //saveAs=new QAction(tr("&Save As..."),this);

    // Set a shortcut. Ctrl+O
    openAct->setShortcut(tr("Ctrl+O"));
    fileMenu->addAction(openAct);

    // Set a shortcut. Ctrl+S
    //saveAs->setShortcut(tr("Ctrl+S"));
    //fileMenu->addAction(saveAs);

    // Open and display the image
    userAction=new ActionButton(this);

    // The action related to the open icon
    QAction *openButton=menuToolBar->addAction(QIcon(":/open.png"),"Open");
    menuToolBar->addSeparator();


    // The action related to the save icon
    QAction *saveButton=menuToolBar->addAction(QIcon(":/save.png"),"Save to txt");
    menuToolBar->addSeparator();

    // The action related to the save icon
    QAction *exportXMLButton = menuToolBar->addAction(QIcon(":/xml.png"),"Export XML");
    menuToolBar->addSeparator();

    // The action related to the draw icon
    QAction *drawButton=menuToolBar->addAction(QIcon(":/draw_rectangle.png"),"Draw Rectangle");
    menuToolBar->addSeparator();

    // The action related to the erase icon
    QAction *eraseButton=menuToolBar->addAction(QIcon(":/cursor_erase.png"),"Erase Rectangle");
    menuToolBar->addSeparator();

    // The action related to the drag icon
    QAction *dragButton=menuToolBar->addAction(QIcon(":/cursor_hand.png"),"Drag");
    menuToolBar->addSeparator();

    // The action related to the zoom in icon
    QAction *zoomInButton=menuToolBar->addAction(QIcon(":/zoom_in.png"),"Zoom In");
    menuToolBar->addSeparator();

    // The action related to the zoom out icon
    QAction *zoomOutButton=menuToolBar->addAction(QIcon(":/zoom_out.png"),"Zoom Out");
    menuToolBar->addSeparator();

    // The action related to the modification button
    QAction *modifyButton=menuToolBar->addAction(QIcon(":/pencil.png"),"Modify Rectangle");
    menuToolBar->addSeparator();

    // The action related to the arrow button
    QAction *arrowButton=menuToolBar->addAction(QIcon(":/cursor-arrow.png"),"Arrow cursor");
    menuToolBar->addSeparator();

    // Connect all these events to one slot in the ActionButton class
    connect (openAct, SIGNAL(triggered()), userAction,SLOT(open()));
    connect (openButton, SIGNAL(triggered()), userAction,SLOT(open()));

    //connect (saveAs,SIGNAL(triggered()),userAction,SLOT(saveMenu()));
    connect (saveButton,SIGNAL(triggered()),userAction,SLOT(saveButton()));
    connect (exportXMLButton,SIGNAL(triggered()),userAction,SLOT(exportXMLButton()));
    connect (drawButton,SIGNAL(triggered()),userAction,SLOT(drawButton()));
    connect (eraseButton,SIGNAL(triggered()),userAction,SLOT(eraseButton()));
    connect (zoomInButton,SIGNAL(triggered()),userAction,SLOT(zoomInButton()));
    connect (zoomOutButton,SIGNAL(triggered()),userAction,SLOT(zoomOutButton()));
    connect (modifyButton,SIGNAL(triggered()),userAction,SLOT(modifyButton()));
    connect (dragButton,SIGNAL(triggered()),userAction,SLOT(dragButton()));
    connect (arrowButton,SIGNAL(triggered()),userAction,SLOT(arrowButton()));
}
