/**
 * \class ImageGraphicsView
 *
 *
 * \brief Displays the image
 *
 * This class displays the image chosen by the user.
 *
 * \author $Author: David Carmona-Moreno $
 *
 * \version $Revision: 1.0 $
 *
 * \date $Date: 2016/01/11 14:00:00 $
 * \bug Not known bugs.
 *
 * Contacts: nikolaos.arvanitopoulos@epfl.ch and david.carmona-moreno@epfl.ch
 *
 * Created on: Mon Jan 12 14:00:00 2016
 *
 */

#ifndef DISPLAYIMAGE
#define DISPLAYIMAGE

#include <QMainWindow>
#include <QString>
#include <QGraphicsScene>
#include <QGraphicsView>

#include "filereader.h"
#include "filereaderxml.h"
#include "image.h"
#include "createfileabstraction.h"
#include "imagegraphicsscene.h"
#include "rectangledraw.h"
#include "fileexistswindow.h"

class ImageGraphicsView:public QGraphicsView
{
    Q_OBJECT

private:

    // The application Main Window
    QMainWindow *mainWindow;

    // The image the user wants to work with
    Image *image;

    // The file associated to the image
    CreateFileAbstraction *file;
    CreateFileAbstraction *fileXML;


    // The application scene
    ImageGraphicsScene *rectangle;

    // The name of the file containing the image
    QString *fileName;

    // The object which is going to read all the rectangles information
    FileReader *fileReader;
    FileReaderXML *fileReaderXML;

    //Variable to check if user has opened a XML or txt file
    QRegularExpressionMatch XMLmatch;



    // Object which is going to add to the selected rectangle
    // the litte icon indicating that th rectangle has already been annotated
    AddIconPicture *addIconPicture;

    // Window warning the user that the image is already linked to a text file
    FileExistsWindow *existsWindow;

    // Checks if the application is in "Draw" mode
    bool drawStarted;

    // Checks if the application is in "Drag" mode
    bool dragButton;

    // Checks if the user has opened the image directly from its source file
    // or using the text file
    bool readFile;

    int selectedTool;

    QRect y;

public:

    /** @brief The constructor of the ImageGraphicsView class
     *  @param _mainWindow_1 The application Main Window
     */
    ImageGraphicsView(QMainWindow *mainWindow_1):QGraphicsView(),mainWindow(mainWindow_1),image(NULL),
        fileName(NULL),dragButton(false),rectangle(NULL),file(NULL),fileReader(NULL),readFile(false),
        addIconPicture(NULL),existsWindow(NULL)
    {
        // Set the mouse tracking to true
        this->setMouseTracking(true);
    }

    /** @brief 1° step for displaying the image
     *  @param fileName The filepath of the image to display
     *  @return true if the image is displayed, false if not
     */
    virtual bool display(QString &fileName);

    /** @brief Deprecated method. Will be removed in a future release
     */
    virtual void setName(QString *filename);

    /** @brief Returns the application scene
     *  @return The application scene
     */
    virtual ImageGraphicsScene* getScene();

    /** @brief Sets the state of the variable representing the state of the Drag icon
     *  @return True if the user has pressed the Drag icon, False if not
     */
    virtual void setDragButton(bool value);

    /** @brief Enables the drag mode
     *  @return void
     */
    virtual void dragEnable();

    /** @brief Disables the drag mode
     *  @return void
     */
    virtual void dragDisable();

    /** @brief Sets the cursor to be a cross when the user presses the draw icon
     *  @return void
     */
    virtual void cursorActivate();

    /** @brief Sets the cursor to be an arrow when the user stops drawing
     *  @return void
     */
    virtual void cursorDesactivate();



protected:

    /** @brief 2° for drawing the image
     *  @return void
     */
    void drawBackground();

    /** @brief Zoom In and Zoom Out events
     *  @param event The Zoom In or Zoom out event
     */
    void wheelEvent(QWheelEvent *event);
};

#endif // DISPLAYIMAGE

