#include "imagegraphicsview.h"

bool ImageGraphicsView::display(QString &fileName){

    QRegularExpression pattern(".txt");
    QRegularExpressionMatch match = pattern.match(fileName);

    QRegularExpression XMLpattern(".xml");
    XMLmatch = XMLpattern.match(fileName);


    if(!match.hasMatch() && !XMLmatch.hasMatch()){
        this->setName(&fileName);
        this->drawBackground();
        qInfo() <<" no match";
        this->readFile=false;
        return true;

    }else if (XMLmatch.hasMatch()){
        this->setName(&fileName);
        this->readFile=true;
       // fileXML=new CreateFileAbstraction(fileName);
        qInfo() << "match xml1";

        fileXML =new CreateFileAbstraction(fileName);

        if(fileXML==NULL){
            return false;
        }

        fileReaderXML=new FileReaderXML(fileName);

        if(fileReaderXML==NULL){
            return false;
        }





        fileReader=new FileReader(fileName);

        if(fileReader==NULL){
            return false;
        }




        this->drawBackground();

        return true;
    }else if (match.hasMatch()){
        this->setName(&fileName);
        this->readFile=true;

        file=new CreateFileAbstraction(fileName);

        if(file==NULL){
            return false;
        }
        fileReader=new FileReader(fileName);

        if(fileReader==NULL){
            return false;
        }
        this->drawBackground();

        return true;
    }
    return false;
}

void ImageGraphicsView::drawBackground()
{
    if(readFile==true){

       // The image we want to display
        if(XMLmatch.hasMatch()){
            QString filename = *(this->fileName);
            fileReaderXML->readFileXML(filename);
            fileReader->setList(fileReaderXML->getList());
            fileReader->setImage(fileReaderXML->getImage());
            file = fileXML ;
        }
        else{
            fileReader->readFile();
        }
       image=fileReader->getImage();
       file->setImage(image);       
       mainWindow->setWindowTitle(*fileName+" - "+" Ground Truthing GUI");

       rectangle = new ImageGraphicsScene(this,image,image->rect(),file);

       int j=0;
       while(j!=(fileReader->getList().size())){

          // Each element of the list is a rectangle
          RectangleDraw* buf=fileReader->getList().at(j);
          buf->setPen(QPen(Qt::red,4,Qt::SolidLine));
          this->rectangle->addItem(buf);
          this->rectangle->setId(buf->getId());

          if(buf->getPoint().x()!=0&&buf->getPoint().y()!=0&&buf->getAnnotation()!="Insert your annotation"){
            addIconPicture=new AddIconPicture(this->rectangle,buf);
          }
          j=j+1;
       }
       j=0;

       this->rectangle->setList(fileReader->getList());

       this->setScene(rectangle);

       mainWindow->setCentralWidget(this);

       mainWindow->setWindowFilePath(*fileName);
       this->show();

    }
    else {

      // The image we want to display
      image=new Image(*fileName);
      file=new CreateFileAbstraction(*image);


      file->createFile();

      mainWindow->setWindowTitle(*fileName+" - "+" Ground Truthing GUI");
      rectangle=new ImageGraphicsScene(this,image,image->rect(),file);

      this->setScene(rectangle);

      mainWindow->setCentralWidget(this);

      mainWindow->setWindowFilePath(*fileName);

      this->show();

      if(file->fileExists()==true){
          existsWindow=new FileExistsWindow();
      }
    }
}

void ImageGraphicsView::setName(QString *filename){
    this->fileName=filename;
}

ImageGraphicsScene* ImageGraphicsView::getScene(){
    return rectangle;
}

void ImageGraphicsView::setDragButton(bool value){
    this->dragButton=value;

    if(this->dragButton==true){
        this->dragEnable();
    }else{
        this->dragDisable();
    }
}

void ImageGraphicsView::dragEnable(){
    this->setDragMode(QGraphicsView::ScrollHandDrag);
}

void ImageGraphicsView::dragDisable(){
    this->setDragMode(QGraphicsView::NoDrag);
}

void ImageGraphicsView::wheelEvent(QWheelEvent *event){

    this->setTransformationAnchor(QGraphicsView::AnchorUnderMouse);
    double scaleFactor = 1.15;
    if(event->delta() > 0) {
        // Zoom in
        this-> scale(scaleFactor, scaleFactor);

    } else {
        // Zooming out
        this->scale(1.0 / scaleFactor, 1.0 / scaleFactor);
    }
}

void ImageGraphicsView::cursorActivate(){
    this->setCursor(Qt::CrossCursor);
}

void ImageGraphicsView::cursorDesactivate(){
    this->setCursor(Qt::ArrowCursor);
}
