/**
 * \class Image
 *
 *
 * \brief Inherits the QPixmap class.
 *
 * The image class provides an interface for reading from and writing to files.
 *
 * \author David Carmona-Moreno
 *
 * \version  1.0
 *
 * \date 2016/01/11 14:00:00
 * \bug Not known bugs
 *
 * Contacts: nikolaos.arvanitopoulos@epfl.ch and david.carmona-moreno@epfl.ch
 *
 * Created on: Mon Jan 12 14:00:00 2016
 *
 */

#ifndef IMAGE
#define IMAGE

#include <QPixmap>
#include <QString>
#include <QDebug>
#include <QPainter>

#include "fileabstraction.h"

class Image:public QPixmap{

private:

    // Image name pointer
    QString imageName;

    // The image file path
    QString ImagefilePath;

    // The file related to the image
    FileAbstraction *file;

public:

    /** @brief The constructor of the Image class
     *  @param ImagefilePath_1 The filepath of the image
     */
    Image(const QString ImagefilePath_1):
        QPixmap(ImagefilePath_1),ImagefilePath(ImagefilePath_1){}

    /** @brief Class default constructor
     */
    Image(){};

    /** @brief Class destructor
     */
    virtual ~Image(){}

    /** @brief Returns only the image name (not the filepath)
     *  @return The image name
     */
    virtual QString getImageName() const;

    /** @brief Set the image filepath
     *  @param imageName The image filepath
     *  @return void
     */
    virtual void setImageName(QString imageName);

    /** @brief Returns the image filepath
     *  @return The image filepath
     */
    virtual QString getImageFilePath() const;

    /** @brief Sets the image filepath
     *  @param filePath The image filepath
     */
    virtual void setImageFilePath(QString filePath);
};

#endif // IMAGE

