#include "filewritterxml.h"
#include <QDebug>
#include <iostream>
#include <QFile>
#include <QXmlStreamWriter>
#include "createfileabstraction.h"



FileWritterXML::FileWritterXML(QString imageName, QList<RectangleDraw*> list)
{

    //QString filename = QFileDialog::getSaveFileName(this,tr("Save Xml"), ".", tr("Xml files (*.xml)"));



        QString imgfilename = imageName + ".xml";

        QRegExp rx("img"); //RegEx for ' ' or ',' or '.' or ':' or '\t'
        QStringList filemameList = imgfilename.split(rx);
        QString filename = filemameList[0];
        filename = filename + "GT_with_transcription" + filemameList[1];

        QFile file(filename);
        qInfo() << filename;
        file.open(QIODevice::WriteOnly);

        QXmlStreamWriter xmlWriter(&file);
        xmlWriter.setAutoFormatting(true);
        xmlWriter.writeStartDocument();
        xmlWriter.writeStartElement("DOCUMENT");

        xmlWriter.writeTextElement("IMG_NAME",imageName);


        int j=0;

        while(j!=(list.size())){
            xmlWriter.writeStartElement("WORD");

         // Each element of the list is a rectangle
         RectangleDraw* buf=list.at(j);

         // Write in the file the rectangle id
         xmlWriter.writeTextElement("ID",QString::number(buf->getId()));
         xmlWriter.writeTextElement("x",QString::number(buf->rect().topLeft().x()));
         xmlWriter.writeTextElement("y",QString::number(buf->rect().topLeft().y()));
         xmlWriter.writeTextElement("w",QString::number(buf->rect().width()));
         xmlWriter.writeTextElement("h",QString::number(buf->rect().height()));
         xmlWriter.writeTextElement("wn",QString(buf->getWordNumber()));
         xmlWriter.writeTextElement("ln",QString(buf->getLineNumber()));
         xmlWriter.writeTextElement("c",QString(buf->getAnnotation()));
         j=j+1;
         xmlWriter.writeEndElement();

        }
        xmlWriter.writeEndElement();


        file.close();
}
