/**
 * \class FileWriter
 *
 *
 * \brief Write in a text file.
 *
 * The FileWriter provides the tools which allow to write content in a text file.
 *
 * \author David Carmona-Moreno
 *
 * \version  1.0
 *
 * \date 2016/01/11 14:00:00
 * \bug Not known bugs
 *
 * Contacts: nikolaos.arvanitopoulos@epfl.ch and david.carmona-moreno@epfl.ch
 *
 * Created on: Mon Jan 12 14:00:00 2016
 *
 */

#ifndef FILEWRITER
#define FILEWRITER

#include "fileabstraction.h"
#include "createfileabstraction.h"

class FileWriter
{

private:

    // The file related to the image
    CreateFileAbstraction *createfileabstraction;

    // TextStream pipeline
    QTextStream outStream;

public:

    /** @brief The constructor of the FileWriter class
     *  @param cfa_1 The text file in which we want to write all the rectangle informations
     */
    FileWriter(CreateFileAbstraction *cfa_1):createfileabstraction(cfa_1),
        outStream(cfa_1->getFile())
    {

    }

    /** @brief Writes the Top-Left coordinates
     *  @param x The x Top-Left coordinate
     *  @param y The y Top-Left coordinate
     *  @return void
     */
    virtual void writeFilePoint(int pointx,int pointy);

    /** @brief Writes the ID
     *  @param id The rectangle id
     *  @return void
     */
    virtual void writeFileRectangleId(int id);

    /** @brief Writes the rectangle height and width
     *  @param width The rectangle width
     *  @param height The rectangle height
     *  @return void
     */
    virtual void writeFileRectangleGeo(int width, int height);

    /** @brief Writes the user's comment
     *  @param comment The user's comment
     *  @return void
     */
    virtual void writeComment(QString comment);

    /** @brief Writes the word number
     *  @param word The word number
     *  @return void
     */
    virtual void writeWordNumber(QString word);

    /** @brief Writes the line number
     *  @param line The line number
     *  @return void
     */
    virtual void writeLineNumber(QString line);

    /** @brief Writes image filepath
     *  @param line The image filepath
     *  @return void
     */
    virtual void writeImageName(QString line);

    /** @brief Goes to the next line
     *  @note \r\n is the change line operation in Windows. The developer has to change it according to his Operating System.
     *  @return void
     */
    virtual void changeLine();

    /** @brief Returns the file we are writing in
     *  @return The file we are writing in
     */
    virtual CreateFileAbstraction* getCreateFileAbstraction()const;
};

#endif // FILEWRITER

