#ifndef FILEREADERXML_H
#define FILEREADERXML_H

#include "rectangledraw.h"
#include "image.h"
#include <QXmlStreamReader>
#include <QDebug>
#include <QFile>
#include <QList>
#include <QPointF>
#include<iostream>

class FileReaderXML
{
private:
    // The file attached to the image containing all the information
    QFile *file;

    // The list which will contain the rectangles
    QList<RectangleDraw*> list;

    // The rectangle described by all the information we have extracted from the text file
    RectangleDraw *rect;

    // The image filepath
    QString image_path;

    // The image associated to the file
    Image *image;

public:
    FileReaderXML(QString file_path);


    /** @brief Reads one line of the file and returns it
     *  @return The line
     */
    virtual QString readFileXML(QString file_path);

    /** @brief Returns a list of all the rectangles described in the text file
     *  @return The rectangles list
     */
    virtual QList<RectangleDraw *> getList()const;

    /** @brief Returns the image filepath written in the file
     *  @return The image filepath
     */
    virtual QString getImagePath()const;

    /** @brief Returns the image
     *  @return The image
     */
    virtual Image* getImage()const;
};

#endif // FILEREADERXML_H
