#include "filereaderxml.h"

FileReaderXML::FileReaderXML(QString file_path)
{

    file = new QFile(file_path);

}

QString FileReaderXML::readFileXML(QString file_path){



    QXmlStreamReader Rxml;
    QString filename = file_path;
    QFile file(filename);
            if (!file.open(QFile::ReadOnly | QFile::Text))
        {
            std::cerr << "Error: Cannot read file " << qPrintable(filename)
                      << ": " << qPrintable(file.errorString())
                      << std::endl;

        }

        Rxml.setDevice(&file);
        Rxml.readNext();


        while(!Rxml.atEnd())
            {
             //   if(Rxml.isStartElement())
               // {
                    if(Rxml.name() == "IMG_NAME")
                    {
                        QString image_path = Rxml.readElementText();
                        Rxml.readNextStartElement();
//                        qInfo() << image_path;
                        image= new Image(image_path);


                    }
                    else if(Rxml.name() == "WORD"){
                        Rxml.readNextStartElement();
                        // Create a new RectangleDraw
                        rect=new RectangleDraw();


                        if(Rxml.name() == "ID")
                        {
                            QString id = Rxml.readElementText();
                            Rxml.readNextStartElement();
                            qInfo() << id;
                            rect->setId(id.toInt());

                        }
                        QString x,y;
                        if(Rxml.name() == "x")
                        {
                            x = Rxml.readElementText();
                            Rxml.readNextStartElement();
//                            qInfo() << x;
                        }
                        if(Rxml.name() == "y")
                        {
                             y = Rxml.readElementText();
                            Rxml.readNextStartElement();
//                            qInfo() << y;
                        }
                        rect->setPoint(QPointF(x.toInt(),y.toInt()));

                        QString w,h;
                        if(Rxml.name() == "w")
                        {
                             w = Rxml.readElementText();
                            Rxml.readNextStartElement();
//                            qInfo() << w;
                        }
                        if(Rxml.name() == "h")
                        {
                             h = Rxml.readElementText();
                            Rxml.readNextStartElement();
//                            qInfo() << h;
                        }
                        rect->setRect(x.toInt(),y.toInt(),w.toInt(),h.toInt());

                        if(Rxml.name() == "wn")
                        {
                            QString wn = Rxml.readElementText();
                            Rxml.readNextStartElement();
//                            qInfo() << wn;
                            rect->setWordNumber(wn);

                        }
                        if(Rxml.name() == "ln")
                        {
                            QString ln = Rxml.readElementText();
                            Rxml.readNextStartElement();
//                            qInfo() << ln;
                            rect->setLineNumber(ln);

                        }
                        if(Rxml.name() == "c")
                        {
                            QString c = Rxml.readElementText();
                            Rxml.readNextStartElement();
//                            qInfo() << c;
                            rect->setAnnotation(c);

                        }
                        this->list.append(rect);
                        this->rect=NULL;

                    }
                    else{
                        Rxml.readNextStartElement();
                        qInfo() <<"nextElt";
                    }
               // }


              //  else{
             //     Rxml.readNext();
            //  }

        }

    file.close();

            if (Rxml.hasError())
        {
           std::cerr << "Error: Failed to parse file "
                     << qPrintable(filename) << ": "
                     << qPrintable(Rxml.errorString()) << std::endl;
            }
        else if (file.error() != QFile::NoError)
        {
            std::cerr << "Error: Cannot read file " << qPrintable(filename)
                      << ": " << qPrintable(file.errorString())
                      << std::endl;
        }








    /*if(!(file->isOpen())){
        return 0;
    }

    // Count the number of lines
    int lineCount=1;

    while (!inStream->atEnd())
     {

        QString line = inStream->readLine();
        ExtractInformation extract(line);

        // First line: we only want to extract the image file path
        if(lineCount==1){

            this->image_path=extract.extractImagePath();
            // The image associated to the text file
            image= new Image(image_path);

        }else{

            // Create a new RectangleDraw
            rect=new RectangleDraw();

            rect->setId(extract.extractId().toInt());
            rect->setPoint(QPointF(extract.extractTopLeftX().toInt(),extract.extractTopLeftY().toInt()));
            rect->setWordNumber(extract.extractWordNumber());
            rect->setLineNumber(extract.extractLineNumber());
            rect->setAnnotation(extract.extractAnnotation());
            rect->setRect(extract.extractTopLeftX().toInt(),extract.extractTopLeftY().toInt(),extract.extractWidth().toInt(),extract.extractHeight().toInt());

            this->list.append(rect);

        }
        lineCount=lineCount+1;
        this->rect=NULL;
     }

     this->rect=NULL;
     file->close()*/
     return 0;
}

QList<RectangleDraw*> FileReaderXML::getList()const{
     return list;
}

QString FileReaderXML::getImagePath()const{
     return image_path;
}

Image* FileReaderXML::getImage()const{
    return image;
}
