/**
 * \class FileReader
 *
 *
 * \brief Reads the text file content.
 *
 * The FileReader provides the tools which allow to read a text file associated to a TIF image.
 *
 * \author David Carmona-Moreno
 *
 * \version  1.0
 *
 * \date 2016/01/11 14:00:00
 * \bug Not known bugs
 *
 * Contacts: nikolaos.arvanitopoulos@epfl.ch and david.carmona-moreno@epfl.ch
 *
 * Created on: Mon Jan 12 14:00:00 2016
 *
 */

#ifndef FILEREADER
#define FILEREADER

#include "QTextStream"
#include "extractinformation.h"
#include "rectangledraw.h"
#include "image.h"

#include <QDebug>
#include <QFile>
#include <QList>
#include <QPointF>

class FileReader{

private:


    // The input text stream from the file
    QTextStream *inStream;

    // The line in the text file we want to extract the information
    QString line;

    // The file attached to the image containing all the information
    QFile *file;

    // The list which will contain the rectangles
    QList<RectangleDraw*> list;

    // The rectangle described by all the information we have extracted from the text file
    RectangleDraw *rect;

    // The image filepath
    QString image_path;

    // The image associated to the file
    Image *image;

    //File path
    QString filePath;

public:

    /** @brief The constructor of the FileReader class
     *  @param file_path The filepath of the text file we want to read
     */
    FileReader(QString file_path):image_path("NULL"),image(NULL)
    {

        file = new QFile(file_path);
        inStream = new QTextStream(file);
    }

    /** @brief Reads one line of the file and returns it
     *  @return The line
     */
    virtual QString readFile();

    /** @brief Returns a list of all the rectangles described in the text file
     *  @return The rectangles list
     */
    virtual QList<RectangleDraw *> getList()const;

    /** @brief Returns the image filepath written in the file
     *  @return The image filepath
     */
    virtual void setList(QList<RectangleDraw *> list);

    /** @briefset the image filepath written in the file
     *  @param The list
     */

    virtual void setImage(Image *image);

    virtual QString getImagePath()const;

    /** @brief Returns the image
     *  @return The image
     */
    virtual Image* getImage()const;


};

#endif // FILEREADER

