#include "filereader.h"
#include "qDebug"

QString FileReader::readFile(){




    file->open(QIODevice::ReadOnly);

    if(!(file->isOpen())){
        return 0;
    }

    // Count the number of lines
    int lineCount=1;

    while (!inStream->atEnd())
     {

        QString line = inStream->readLine();
        ExtractInformation extract(line);

        // First line: we only want to extract the image file path
        if(lineCount==1){

            this->image_path=extract.extractImagePath();
            // The image associated to the text file
            image= new Image(image_path);

        }else{

            // Create a new RectangleDraw
            rect=new RectangleDraw();

            rect->setId(extract.extractId().toInt());
            rect->setPoint(QPointF(extract.extractTopLeftX().toInt(),extract.extractTopLeftY().toInt()));
            rect->setWordNumber(extract.extractWordNumber());
            rect->setLineNumber(extract.extractLineNumber());
            rect->setAnnotation(extract.extractAnnotation());
            rect->setRect(extract.extractTopLeftX().toInt(),extract.extractTopLeftY().toInt(),extract.extractWidth().toInt(),extract.extractHeight().toInt());

            this->list.append(rect);

        }
        lineCount=lineCount+1;
        this->rect=NULL;  
     }

     this->rect=NULL;
     file->close();
     return 0;
}

QList<RectangleDraw*> FileReader::getList()const{
     return list;
}

void FileReader::setList(QList<RectangleDraw *> list) {
    this->list = list;
}

QString FileReader::getImagePath()const{
     return image_path;
}

Image* FileReader::getImage()const{
    return image;
}

void FileReader::setImage(Image *image){
     this->image = image;
}
