/**
 * \class FileExistsWindow
 *
 *
 * \brief Warning window.
 *
 * The FileExistsWindow described a window which warns the user that a text file is already associated to an image.
 *
 * \note Inherits the QWidget class.
 * \author David Carmona-Moreno
 *
 * \version  1.0
 *
 * \date 2016/01/11 14:00:00
 * \bug Not known bugs
 *
 * Contacts: nikolaos.arvanitopoulos@epfl.ch and david.carmona-moreno@epfl.ch
 *
 * Created on: Mon Jan 12 14:00:00 2016
 *
 */

#ifndef FILEEXISTSWINDOW
#define FILEEXISTSWINDOW

#include <QWidget>
#include <QObject>
#include <QLabel>
#include <QVBoxLayout>
#include <QPushButton>

class FileExistsWindow:public QWidget{
      Q_OBJECT

private:

    // Create a push button
    QPushButton* push;

    // Create a horizontal layout containing the push button
    QHBoxLayout *push_layout;

    // Create a vertical layout
    QVBoxLayout* layout;

    // Create the label which is going to display the
    QLabel *text;


public:

    /** @brief The constructor of the FileExistsWindow
     */
    FileExistsWindow(){

        text=new QLabel(this);
        text->setText("A text file is already associated to the image."
                      "If you press the save button, you will overwrite it.");

        push=new QPushButton(this);
        push->setText("Proceed");

        layout=new QVBoxLayout(this);
        push_layout=new QHBoxLayout();

        push_layout->addWidget(push);

        layout->addWidget(text);
        layout->addLayout(push_layout);

        this->setWindowTitle("Warning: A text file already exists.");
        QObject::connect(push,SIGNAL(clicked()),this,SLOT(quit()));
        this->show();

    }

private slots:

    /** @brief "Quit window" event
     *  @return Void.
     */
    void quit();
};

#endif // FILEEXISTSWINDOW

