/**
 * \class FileAbstraction
 *
 *
 * \brief Inherits the QFile class.
 *
 * Provides an interface for reading from and writing to files.
 *
 * \author David Carmona-Moreno
 *
 * \version  1.0
 *
 * \date 2016/01/11 14:00:00
 * \bug Not known bugs
 *
 * Contacts: nikolaos.arvanitopoulos@epfl.ch and david.carmona-moreno@epfl.ch
 *
 * Created on: Mon Jan 12 14:00:00 2016
 *
 */

#ifndef FILEABSTRACTION
#define FILEABSTRACTION

#include <QFile>

class FileAbstraction:public QFile{

private:

    // The file name related to the image
    QString fileName;

public:

    /** @brief The constructor of the FileAbstraction class
     *  @param _fileName_1 The filepath of the text file associated to the image.
     */
    FileAbstraction(QString fileName_1):QFile(fileName_1),fileName(fileName_1){}

    /** @brief Class destructor
     */
    virtual ~FileAbstraction(){}

};

#endif // FILEABSTRACTION

