/**
 * \class ExtractInformation
 *
 *
 * \brief Extracts all the rectangles information contained in a text file.
 *
 * This class extracts all the rectangles information inserted previously by the user.
 *
 * \note The following information is extracted: Image filepath,ID,Top-left x coordinate,Top-Left y coordinate,Width,Height,Annotation
 * ,Word number,Line number.
 *
 * \author $Author: David Carmona-Moreno $
 *
 * \version $Revision: 1.0 $
 *
 * \date $Date: 2016/01/11 14:00:00 $
 * \bug Not known bugs
 *
 * Contacts: nikolaos.arvanitopoulos@epfl.ch and david.carmona-moreno@epfl.ch
 *
 * Created on: Mon Jan 12 14:00:00 2016
 *
 */

#ifndef EXTRACTINFORMATION
#define EXTRACTINFORMATION

#include <QRegularExpression>
#include <QString>

class ExtractInformation{

private:

    // Line containing the rectangle's information
    QString line;

    // The regular expression
    QRegularExpression regularExpression;

public:

    /** @brief The constructor of the ExtractInformation class
     *  @param _line The line from the text file containing the rectangle informations
     */
    ExtractInformation(QString _line):line(_line)
    {
    }

    /** @brief Extracts the rectangle ID from the line
     *  @return The rectangle ID
     */
    virtual QString extractId();

    /** @brief Extracts the rectangle Top-Left corner (x coordinate)
     *  @return The x coordinate of the rectangle Top-Left corner
     */
    virtual QString extractTopLeftX();

    /** @brief Extracts the rectangle Top-Left corner (y coordinate)
     *  @return The y coordinate of the rectangle Top-Left corner
     */
    virtual QString extractTopLeftY();

    /** @brief Extracts the value of the line number field
     *  @return The value of the line number field
     */
    virtual QString extractLineNumber();

    /** @brief Extracts the value of the word number field
     *  @return The value of the word number field
     */
    virtual QString extractWordNumber();

    /** @brief Extracts the width of the rectangle
     *  @return The rectangle width
     */
    virtual QString extractWidth();

    /** @brief Extracts the height of the rectangle
     *  @return The rectangle height
     */
    virtual QString extractHeight();

    /** @brief Extracts the annotation associated to the rectangle
     *  @return The annotation
     */
    virtual QString extractAnnotation();

    /** @brief Extracts the image filepath
     *  @return The image filepath
     */
    virtual QString extractImagePath();
};

#endif // EXTRACTINFORMATION


