#include "extractinformation.h"
#include <QDebug>

QString ExtractInformation::extractId(){
    regularExpression.setPattern("(\\d+)(?:\\s*)(x:)");
    QRegularExpressionMatch match = regularExpression.match(line);
    if (match.hasMatch()) {
        QString id = match.captured(1);
        return id;
    }
    return 0;
}

QString ExtractInformation::extractTopLeftX(){

    regularExpression.setPattern("(\\d+)(?:\\s*)(y:)");
    QRegularExpressionMatch match = regularExpression.match(line);
    if (match.hasMatch()) {
        QString id = match.captured(1);
        return id;
    }
    return 0;

}

QString ExtractInformation::extractTopLeftY(){

    regularExpression.setPattern("(\\d+)(?:\\s*)(w:)");
    QRegularExpressionMatch match = regularExpression.match(line);
    if (match.hasMatch()) {
        QString id = match.captured(1);
        return id;
    }
    return 0;

}

QString ExtractInformation::extractLineNumber(){

    regularExpression.setPattern("(\\d+)(?:\\s*)(c:)");
    QRegularExpressionMatch match = regularExpression.match(line);
    if (match.hasMatch()) {
        QString id = match.captured(1);
        return id;
    }
    return 0;

}

QString ExtractInformation::extractWordNumber(){

    regularExpression.setPattern("(\\d+)(?:\\s*)(ln:)");
    QRegularExpressionMatch match = regularExpression.match(line);
    if (match.hasMatch()) {
        QString id = match.captured(1);
        return id;
    }
    return 0;
}

QString ExtractInformation::extractWidth(){

    regularExpression.setPattern("(\\d+)(?:\\s*)(h:)");
    QRegularExpressionMatch match = regularExpression.match(line);
    if (match.hasMatch()) {
        QString id = match.captured(1);
        return id;
    }
    return 0;

}

QString ExtractInformation::extractHeight(){

    regularExpression.setPattern("(\\d+)(?:\\s*)(wn:)");
    QRegularExpressionMatch match = regularExpression.match(line);
    if (match.hasMatch()) {
        QString id = match.captured(1);
        return id;
    }
    return 0;

}

QString ExtractInformation::extractAnnotation(){

    regularExpression.setPattern("c:\\s?([^\r\n]*)");//c:\s*(.*$)
    QRegularExpressionMatch match = regularExpression.match(line);
    if (match.hasMatch()) {
        QString id = match.captured(1);
        return id;
    }
    return 0;

}

QString ExtractInformation::extractImagePath(){

    regularExpression.setPattern("([^\r\n]*)");//c:\s*(.*$)
    QRegularExpressionMatch match = regularExpression.match(line);
    if (match.hasMatch()) {
        QString id = match.captured(0);
        return id;
    }
    return 0;
}

