/**
 * \class CreateFileAbstraction
 *
 *
 * \brief Creates a text file related to an image.
 *
 * This class creates a text file when the user opens an image for the first time.
 *
 * \note The text file has the same name as the image to which it is related. It is also
 * created in the same directory.
 *
 * \author $Author: David Carmona-Moreno $
 *
 * \version $Revision: 1.0 $
 *
 * \date $Date: 2016/01/11 14:00:00 $
 * \bug Not known bugs
 *
 * Contacts: nikolaos.arvanitopoulos@epfl.ch and david.carmona-moreno@epfl.ch
 *
 * Created on: Mon Jan 12 14:00:00 2016
 *
 */

#ifndef CREATEFILEABSTRACTION
#define CREATEFILEABSTRACTION

#include <QFile>
#include <QFileInfo>

#include "image.h"
#include "fileabstraction.h"

class CreateFileAbstraction{

private:

    // The file related to the image
    FileAbstraction *file;
    FileAbstraction *fileXML;



    // The image
    Image *image;

    // The file path of the file containing all the information
    QString filePath;

public:

    /** @brief The first constructor of the CreateFileAbstraction class
     *  This constructor is called when the user opens a image which is not associated to a text file
     *  @param image_1 The image to which the text file is going to be associated.
     */
    CreateFileAbstraction(Image &image_1):image(&image_1){}

    /** @brief The second constructor of the CreateFileAbstraction class
     *  This constructor is called when the user opens a text file which is already associated to an image
     *  @param filePath_1 The filepath of the text file
     */
    CreateFileAbstraction(QString filePath_1):filePath(filePath_1){
        file = new FileAbstraction(filePath);
        fileXML = new FileAbstraction(filePath);

    }

    /** @brief Class destructor
     */
    virtual ~CreateFileAbstraction(){}

    /** @brief Creates the text file associated to the image
     *  @return Void.
     */
    virtual void createFile();

    /** @brief Removes the ".tiff" extension from the image filepath
     *
     *  @param filename_with_extension The image filename
     *  @return A filename without the extension ".tiff"
     */


    virtual QString removeExtension(QString filename_with_extension) const;

    /** @brief Returns the text file associated to the image
     *
     *  @return The text file associated to the image
     */
    virtual FileAbstraction* getFile()const;





    /** @brief Returns the image to which the text file is associated
     *  @return The image to which the text file is associated
     */
    virtual Image* getImage()const;

    /** @brief Set the image to which the text file is associated
     *
     *  @param image_1 The image to which the text file is associated
     *  @return Void.
     */
    virtual void setImage(Image *image_1);

    /** @brief Set the text file
     *
     *  @param file_1 The text file
     *  @return Void.
     */
    virtual void setFile(FileAbstraction *file_1);

    /** @brief When the user opens an image, checks if a text file associated to this image already exists
     *  @return True if the text file exists and False if it does not.
     */
    virtual bool fileExists()const;
};

#endif // CREATEFILEABSTRACTION

