#include "createfileabstraction.h"

// Create the file
void CreateFileAbstraction::createFile()
{
    QString filename=image->getImageFilePath();
    QString filename_without_extension;

    // Remove the ".tiff" extension from the file path
    filename_without_extension=this->removeExtension(filename);

    // Create the new file having the same name of the image but with a ".txt" extension
    file=new FileAbstraction(filename_without_extension+".txt");

}





QString CreateFileAbstraction::removeExtension(QString filename_with_extension) const
{
    QString filename_without_extension;

    // Here we are removing the ".tif" extension from the original filename
    filename_without_extension=filename_with_extension.remove(".tif",Qt::CaseSensitive);

    return filename_without_extension;
}

FileAbstraction* CreateFileAbstraction::getFile()const{

    return file;
}





Image* CreateFileAbstraction::getImage()const{
    return image;
}


void CreateFileAbstraction::setImage(Image *image_1){
    this->image=image_1;
}


void CreateFileAbstraction::setFile(FileAbstraction *file_1){
    this->file=file_1;
}

bool CreateFileAbstraction::fileExists()const{

    QString filename=image->getImageFilePath();
    QString filename_without_extension;

    // Remove the ".tiff" extension from the file path
    filename_without_extension=this->removeExtension(filename)+".txt";

    QFileInfo checkFile(filename_without_extension);

    // check if file exists and if yes: Is it really a file and no directory?
    if (checkFile.exists() && checkFile.isFile()) {
         return true;
    }else{
         return false;
    }
}
