/**
 * \class AddIconPicture
 *
 *
 * \brief Adds an icon at the top-left corner of a rectangle.
 *
 * When the user has annotated a rectangle, this class adds an icon at the
 * top-left corner of the latter. It will allow the user to know which rectangles
 * has already been annotated or not.
 *
 * \author $Author: David Carmona-Moreno $
 *
 * \version $Revision: 1.0 $
 *
 * \date $Date: 2016/01/11 14:00:00 $
 * \bug Not known bugs
 *
 * Contacts: nikolaos.arvanitopoulos@epfl.ch and david.carmona-moreno@epfl.ch
 *
 * Created on: Mon Jan 12 14:00:00 2016
 *
 */

#ifndef ADDICONPICTURE
#define ADDICONPICTURE

#include <QGraphicsScene>
#include <QImage>
#include <QGraphicsPixmapItem>
#include <QPixmap>
#include <QPointF>
#include <rectangledraw.h>

class AddIconPicture{

private:

    // The application scene
    QGraphicsScene *scene;

    // The image the user wants to work with
    QImage *image;

    // The little icon which indicates if the user
    // has annotated one rectangle or not
    QGraphicsPixmapItem *item;

public:


    /** @brief The constructor of the AddIconPicture class
     *  @param scene The application QGraphicsScene
     *  @param rectangle A rectangle drawn by the user
     */
    AddIconPicture(QGraphicsScene *scene_1,RectangleDraw *rectangle):scene(scene_1){

        image= new QImage("../Icons/annotation.png");
        item= new QGraphicsPixmapItem(QPixmap::fromImage(*image));
        item->setPos(rectangle->rect().topLeft());
        scene->addItem(item);
        rectangle->setItem(item);
    }

    /** @brief Return the little item which is associated to a rectangle when it is annotated
     *  @return The item associated to the annotated rectangle.
     */
    virtual QGraphicsPixmapItem* getItem()const;
};

#endif // ADDICONPICTURE

