/**
 * \class ActionButton
 *
 *
 * \brief Manages all the Qt signals coming from the main window.
 *
 * This class dispatches all the signals coming from the application Main Window (ImageViewer) to
 * the right classes.
 *
 * \author David Carmona-Moreno
 *
 * \version  1.0
 *
 * \date 2016/01/11 14:00:00
 * \bug Not known bugs
 *
 * Contacts: nikolaos.arvanitopoulos@epfl.ch and david.carmona-moreno@epfl.ch
 *
 * Created on: Mon Jan 12 14:00:00 2016
 *
 */

#ifndef OPENIMAGEFILE
#define OPENIMAGEFILE

#include <QMenu>
#include <QAction>
#include <QtWidgets>
#include <QMainWindow>
#include <QObject>

#include "image.h"
#include "createfileabstraction.h"
#include "imagegraphicsview.h"
#include "saverectangle.h"

class ActionButton:public QObject{

    Q_OBJECT

private:

    // The application Main Window
    QMainWindow *mainWindow;

    // The image the uer wants to work with
    Image *image;

    // The text file associated to the image
    CreateFileAbstraction *file;

    // The image displayer
    ImageGraphicsView *displayImage;

    // The rectangles saver
    SaveRectangle *save;

    // The object which is going to write all the rectangles
    // information in the text file
    FileWriter *fileWriter;

public:

    /** @brief The constructor of the ActionButton class
     *  @param mainWindow_1 The application Main Window
     */
    ActionButton(QMainWindow *mainWindow_1):mainWindow(mainWindow_1),file(NULL),fileWriter(NULL)

    {
        displayImage = new ImageGraphicsView(mainWindow_1);
        save= new SaveRectangle(this->displayImage->getScene());

    }

    /** @brief Class destructor
     */
    virtual ~ActionButton(){}

public slots:

    /** @brief The slot associated to the Open menu
     *  @return Void.
     */
    void open();

    /** @brief The slot associated to the Save Menu
     *  @return Void.
     */
    void saveMenu();

    /** @brief The slot associated to the Draw icon
     *  @return Void.
     */
    void drawButton();

    /** @brief The slot associated to the Erase icon
     *  @return Void.
     */
    void eraseButton();

    /** @brief The slot associated to the Drag icon
     *  @return Void.
     */
    void dragButton();

    /** @brief The slot associated to the Save icon
     *  @return Void.
     */
    void saveButton();

    /** @brief The slot associated to the Zoom in icon
     *  @return Void.
     */

    void exportXMLButton();

    /** @brief The slot associated to the Zoom in icon
     *  @return Void.
     */
    void zoomInButton();

    /** @brief The slot associated to the Zoom out icon
     *  @return Void.
     */
    void zoomOutButton();

    /** @brief The slot associated to the Modify menu
     *  @return Void.
     */
    void modifyButton();

    /** @brief The slot associated to the Arrow icon
     *  @return Void
     */
     void arrowButton();
};

#endif // OPENIMAGEFILE

