#include "actionbutton.h"
#include <QDebug>
#include <iostream>
using namespace std;

void ActionButton::open()
{
    QStringList mimeTypeFilters;
    foreach (const QByteArray &mimeTypeName, QImageReader::supportedMimeTypes())
        mimeTypeFilters.append(mimeTypeName+".txt");
    mimeTypeFilters.sort();
    const QStringList picturesLocations = QStandardPaths::standardLocations(QStandardPaths::PicturesLocation);

    // This is the FileDialog Box which is going to ask the user which file he wants to open
    QFileDialog dialog(mainWindow,tr("Open File"),
                       picturesLocations.isEmpty() ? QDir::currentPath() : picturesLocations.first());
    dialog.setAcceptMode(QFileDialog::AcceptOpen);
    dialog.setMimeTypeFilters(mimeTypeFilters);
    dialog.selectMimeTypeFilter("image/tiff");

    // Load the file
    while (dialog.exec() == QDialog::Accepted && !displayImage->display((dialog.selectedFiles().first()))) {}
}

void ActionButton::drawButton(){

    if((this->displayImage->getScene())!=NULL){
        this->displayImage->getScene()->setDrawButton(true);
        this->displayImage->setDragButton(false);
        this->displayImage->getScene()->setModify(false);
        this->displayImage->getScene()->setDragButton(false);
        this->displayImage->getScene()->setDoubleClick(false);
        this->displayImage->setCursor(Qt::CrossCursor);
        this->displayImage->getScene()->setIsSelected(false);
    }else{
    }

}

void ActionButton::eraseButton(){

   if((this->displayImage->getScene())!=NULL){
     this->displayImage->getScene()->setEraseButton(true);
     this->displayImage->setDragButton(false);
     this->displayImage->getScene()->setModify(false);
     this->displayImage->getScene()->setDragButton(false);
     this->displayImage->getScene()->setDoubleClick(false);
     this->displayImage->setCursor(*(displayImage->getScene()->getEraseCursor()));
     this->displayImage->getScene()->setIsSelected(false);
   }
   else{
   }
}

void ActionButton::dragButton(){

    if((this->displayImage->getScene())!=NULL){
      this->displayImage->getScene()->setDragButton(true);
      this->displayImage->setDragButton(true);
      this->displayImage->getScene()->setModify(false);
      this->displayImage->getScene()->setDrawButton(false);
      this->displayImage->getScene()->setEraseButton(false);
      this->displayImage->getScene()->setDoubleClick(false);
      this->displayImage->getScene()->setIsSelected(false);

    }else{
    }
}

void ActionButton::saveButton(){

    //qInfo() << "hello" ;
    if((this->displayImage->getScene())!=NULL){
      save->setScene(displayImage->getScene());
      save->saveChanges("txt");
    }else{
    }
}
void ActionButton::exportXMLButton(){

    if((this->displayImage->getScene())!=NULL){
      save->setScene(displayImage->getScene());
      save->saveChanges("xml");
    }else{
    }
}

void ActionButton::zoomInButton(){

    if(this->displayImage->getScene()!=NULL){

       this->displayImage->getScene()->setDragButton(false);
       this->displayImage->setDragButton(false);
       this->displayImage->getScene()->setModify(false);
       this->displayImage->getScene()->setDrawButton(false);
       this->displayImage->getScene()->setEraseButton(false);
       this->displayImage->getScene()->setDoubleClick(false);
       this->displayImage->getScene()->setIsSelected(false);

    }else{
    }

    if((this->displayImage->getScene())!=NULL){
       double scaleFactor = 1.15;

       this->displayImage->scale(scaleFactor, scaleFactor);
    }else{
    }
}

void ActionButton::zoomOutButton(){

    if(this->displayImage->getScene()!=NULL){

      this->displayImage->getScene()->setDragButton(false);
      this->displayImage->setDragButton(false);
      this->displayImage->getScene()->setModify(false);
      this->displayImage->getScene()->setDrawButton(false);
      this->displayImage->getScene()->setEraseButton(false);
      this->displayImage->getScene()->setDoubleClick(false);
      this->displayImage->getScene()->setIsSelected(false);

    }else{

    }

    if((this->displayImage->getScene())!=NULL){

       double scaleFactor = 1.15;
       this->displayImage->scale(1.0 / scaleFactor, 1.0 / scaleFactor);
    }else{
    }
}

void ActionButton::modifyButton(){

    if((this->displayImage->getScene())!=NULL){
        this->displayImage->getScene()->setDrawButton(false);
        this->displayImage->getScene()->setDragButton(false);
        this->displayImage->getScene()->setEraseButton(false);
        this->displayImage->getScene()->setDoubleClick(false);
        this->displayImage->getScene()->setModify(true);
        this->displayImage->setCursor(*(displayImage->getScene()->getModifyCursor()));
        this->displayImage->setDragButton(false);
        this->displayImage->getScene()->setIsSelected(false);
    }else{
    }
}

void ActionButton::saveMenu()
{
    // This is the FileDialog box asking to save the text file
    QFileDialog dialog(mainWindow,tr("Save As"),"",tr("Text file (*.txt)"));
    dialog.setAcceptMode(QFileDialog::AcceptSave);

    // Retrieve the current directory
    if( dialog.exec() ) {

        QString filePath = dialog.selectedFiles()[0];

        file=new CreateFileAbstraction(filePath);

        fileWriter=new FileWriter(file);

        this->save->saveAs(file,fileWriter);
    }
}

void ActionButton::arrowButton()
{
    if((this->displayImage->getScene())!=NULL){
        this->displayImage->getScene()->setDrawButton(false);
        this->displayImage->getScene()->setDragButton(false);
        this->displayImage->getScene()->setEraseButton(false);
        this->displayImage->getScene()->setDoubleClick(false);
        this->displayImage->getScene()->setModify(false);
        this->displayImage->setCursor(Qt::ArrowCursor);
        this->displayImage->setDragButton(false);
        this->displayImage->getScene()->setIsSelected(false);
    }else{
    }
}
