/*
 * Decompiled with CFR 0.152.
 */
package FijiITKInterface;

import FijiITKInterface.TubularGeodesics;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.io.FileInfo;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij3d.Content;
import ij3d.Image3DUniverse;
import ij3d.Pipe;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.vecmath.Color3f;

public class TubularGeodesics_Plugin
implements MouseListener,
MouseMotionListener,
PlugIn {
    TubularGeodesics ti = new TubularGeodesics();
    static final boolean MULTICOLORED = true;
    JPanel mainPane;
    ImagePlus imagePlus;
    int Slice1;
    int Slice2;
    int NSlices;
    int Nscales;
    int imageType;
    int width;
    int height;
    double maximumScale;
    double minimumScale;
    float PxlDth;
    boolean position_checked = false;
    boolean showFilteredImages;
    boolean ROIpt_1_2 = true;
    Point p;
    Point ROI_p1;
    Point ROI_p2;
    float[] StackPixelDataOut;
    byte[] StackpixelData;
    Calibration Calib;
    Image3DUniverse univ;

    public void run(String string) {
        this.imagePlus = IJ.getImage();
        ImageStack imageStack = this.imagePlus.getImageStack();
        ImageCanvas imageCanvas = this.imagePlus.getCanvas();
        this.ROIpt_1_2 = true;
        this.ROI_p1 = new Point();
        this.ROI_p2 = new Point();
        this.ROI_p1.x = 0;
        this.ROI_p1.y = 0;
        this.ROI_p2.x = this.imagePlus.getWidth();
        this.ROI_p2.y = this.imagePlus.getHeight();
        if (this.imagePlus == null) {
            IJ.error((String)"No image was open...");
            return;
        }
        this.imageType = this.imagePlus.getType();
        if (this.imageType != 0 && this.imageType != 3) {
            IJ.error((String)"Not an 8-bit image");
            return;
        }
        ByteProcessor byteProcessor = (ByteProcessor)this.imagePlus.getProcessor();
        byte[] byArray = (byte[])byteProcessor.getPixels();
        imageCanvas.addMouseListener((MouseListener)this);
        imageCanvas.addMouseMotionListener((MouseMotionListener)this);
        FileInfo fileInfo = this.imagePlus.getOriginalFileInfo();
        this.Calib = this.imagePlus.getCalibration();
        this.NSlices = imageStack.getSize();
        this.width = this.imagePlus.getWidth();
        this.height = this.imagePlus.getHeight();
        this.PxlDth = (float)this.Calib.pixelDepth;
        byte[] byArray2 = new byte[this.width * this.height];
        this.StackpixelData = new byte[this.width * this.height * this.NSlices];
        for (int i = 0; i < this.NSlices; ++i) {
            ByteProcessor byteProcessor2 = (ByteProcessor)imageStack.getProcessor(i + 1);
            byArray2 = (byte[])byteProcessor2.getPixels();
            for (int j = 0; j < this.width * this.height; ++j) {
                this.StackpixelData[this.width * this.height * i + j] = byArray2[j];
            }
        }
        GenericDialog genericDialog = new GenericDialog("Optimally Oriented Flux Options");
        double d = Math.abs(this.Calib.pixelWidth);
        genericDialog.addNumericField("Number of scales", 1.0, 0);
        genericDialog.addNumericField("Minimum scale", d, 6);
        genericDialog.addNumericField("Maximum scale", d, 6);
        genericDialog.addCheckbox("Show filtered images at each scale:", false);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        this.Nscales = (int)Math.round(genericDialog.getNextNumber());
        if (this.Nscales < 1) {
            IJ.error((String)"The minimum number of scales to try is 1");
            return;
        }
        this.minimumScale = genericDialog.getNextNumber();
        this.maximumScale = genericDialog.getNextNumber();
        if (this.maximumScale < this.minimumScale) {
            IJ.error((String)"The maximum scale cannot be less than the minimum scale");
            return;
        }
        this.showFilteredImages = genericDialog.getNextBoolean();
        this.StackPixelDataOut = new float[this.Nscales * this.width * this.height * this.NSlices];
        this.univ = new Image3DUniverse();
        this.univ.getViewingPlatform().setNominalViewingTransform();
        this.univ.show();
        Content content = this.univ.addVoltex(this.imagePlus);
        content.setLocked(true);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.p = mouseEvent.getPoint();
        if (this.ROIpt_1_2) {
            this.Slice1 = this.imagePlus.getCurrentSlice();
            this.ROI_p1.x = this.p.x;
            this.ROI_p1.y = this.p.y;
            this.ROIpt_1_2 = false;
            IJ.error((String)("Point1: " + this.ROI_p1.x + "," + this.ROI_p1.y + " Slice :" + this.Slice1));
        } else {
            this.Slice2 = this.imagePlus.getCurrentSlice();
            this.ROI_p2.x = this.p.x;
            this.ROI_p2.y = this.p.y;
            this.ROIpt_1_2 = true;
            this.position_checked = true;
            IJ.error((String)("Point2: " + this.ROI_p2.x + "," + this.ROI_p2.y + " Slice :" + this.Slice2));
        }
        if (this.position_checked) {
            Object object;
            FloatProcessor floatProcessor;
            int n;
            float[] fArray = new float[]{this.ROI_p1.x, this.ROI_p1.y, this.Slice1};
            float[] fArray2 = new float[]{this.ROI_p2.x, this.ROI_p2.y, this.Slice2};
            this.ti.OrientedFlux(this.StackpixelData, this.StackPixelDataOut, this.imageType, this.width, this.height, this.NSlices, this.Calib.pixelWidth, this.Calib.pixelHeight, this.Calib.pixelDepth, this.minimumScale, this.maximumScale, this.Nscales, fArray, fArray2);
            int n2 = 0;
            int n3 = this.width;
            int n4 = this.height;
            ImagePlus imagePlus = new ImagePlus();
            ImageStack imageStack = new ImageStack(this.width, this.height);
            for (n = 0; n < this.NSlices; ++n) {
                float[] fArray3 = new float[n3 * n4];
                for (int i = 0; i < n3 * n4; ++i) {
                    fArray3[i] = this.StackPixelDataOut[n2 + n3 * n4 * n + i];
                }
                floatProcessor = new FloatProcessor(n3, n4, fArray3, null);
                imageStack.addSlice("", (ImageProcessor)floatProcessor);
            }
            imagePlus.setStack(imageStack);
            imagePlus.show();
            n = this.showFilteredImages ? this.Nscales : 1;
            for (int i = 1; i < n; ++i) {
                if (i > 0) {
                    n2 += n3 * n4 * this.NSlices;
                }
                floatProcessor = new ImageStack(n3, n4);
                for (int j = 0; j < this.NSlices; ++j) {
                    object = new float[n3 * n4];
                    for (int k = 0; k < n3 * n4; ++k) {
                        object[k] = this.StackPixelDataOut[n2 + n3 * n4 * j + k];
                    }
                    FloatProcessor floatProcessor2 = new FloatProcessor(n3, n4, object, null);
                    floatProcessor.addSlice("", (ImageProcessor)floatProcessor2);
                }
                String string = "Tubularity" + i;
                object = new ImagePlus(string, (ImageStack)floatProcessor);
                object.show();
            }
            int n5 = 0;
            object = new float[n3 * n4 * this.NSlices];
            int n6 = this.ti.GetPath((float[])object);
            boolean bl = false;
            Color3f color3f = new Color3f(Color.magenta);
            ArrayList arrayList = new ArrayList();
            int n7 = n6 / 4;
            double[] dArray = new double[n7];
            double[] dArray2 = new double[n7];
            double[] dArray3 = new double[n7];
            double[] dArray4 = new double[n7];
            int n8 = 0;
            for (int i = 0; i < n7; ++i) {
                if (i % 8 != 0) continue;
                n5 = i * 4;
                dArray[n8] = object[n5];
                dArray2[n8] = object[n5 + 1];
                dArray3[n8] = object[n5 + 2];
                dArray4[n8] = object[n5 + 3];
                ++n8;
            }
            double[] dArray5 = new double[n8];
            double[] dArray6 = new double[n8];
            double[] dArray7 = new double[n8];
            double[] dArray8 = new double[n8];
            System.arraycopy(dArray, 0, dArray5, 0, n8);
            System.arraycopy(dArray2, 0, dArray6, 0, n8);
            System.arraycopy(dArray3, 0, dArray7, 0, n8);
            System.arraycopy(dArray4, 0, dArray8, 0, n8);
            System.out.println("Adding " + n7 + " points with makeTube");
            double[][][] dArray9 = Pipe.makeTube((double[])dArray5, (double[])dArray6, (double[])dArray7, (double[])dArray8, (int)(bl ? 2 : 1), (int)12, (boolean)bl, (Color3f)color3f, null, arrayList);
            if (dArray9 == null) {
                IJ.error((String)"Generating the 3D surface visualization failed");
                return;
            }
            ArrayList arrayList2 = new ArrayList();
            List list = Pipe.generateTriangles((double[][][])dArray9, (double)1.0, arrayList, arrayList2);
            Content content = this.univ.addTriangleMesh(list, arrayList2, "Example Trace");
            content.setLocked(true);
            this.position_checked = false;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.p = null;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.p = mouseEvent.getPoint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

