/*
 * Decompiled with CFR 0.152.
 */
package FijiITKInterface;

import FijiITKInterface.OOFTubularityMeasure;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.io.FileInfo;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class OOFTubularityMeasure_Plugin
implements MouseListener,
MouseMotionListener,
PlugIn {
    OOFTubularityMeasure ti = new OOFTubularityMeasure();
    boolean ROIpt_1_2 = true;
    boolean position_checked = false;
    static final boolean MULTICOLORED = true;
    JPanel mainPane;
    Point p;
    Point ROI_p1;
    Point ROI_p2;
    int Slice1;
    int Slice2;
    ImagePlus imagePlus;

    protected String getSavePath(FileInfo fileInfo) {
        String string;
        SaveDialog saveDialog;
        String string2 = ".oof.nrrd";
        if (fileInfo == null) {
            saveDialog = new SaveDialog("Save output as...", "image", string2);
        } else {
            string = fileInfo.fileName;
            String string3 = fileInfo.directory;
            String string4 = string;
            saveDialog = new SaveDialog("Save output as...", string3, string4, string2);
        }
        string = null;
        if (saveDialog.getFileName() == null) {
            IJ.error((String)"You must choose a filename - exiting");
            return null;
        }
        string = saveDialog.getDirectory() + saveDialog.getFileName();
        return string;
    }

    public void run(String string) {
        this.imagePlus = IJ.getImage();
        ImageStack imageStack = this.imagePlus.getImageStack();
        ImageCanvas imageCanvas = this.imagePlus.getCanvas();
        if (this.imagePlus == null) {
            IJ.error((String)"No image was open...");
            return;
        }
        int n = this.imagePlus.getType();
        if (n != 0 && n != 3) {
            IJ.error((String)"Not an 8-bit image");
            return;
        }
        ByteProcessor byteProcessor = (ByteProcessor)this.imagePlus.getProcessor();
        byte[] byArray = (byte[])byteProcessor.getPixels();
        this.ROI_p1 = new Point();
        this.ROI_p2 = new Point();
        this.ROI_p1.x = 0;
        this.ROI_p1.y = 0;
        this.ROI_p2.x = this.imagePlus.getWidth();
        this.ROI_p2.y = this.imagePlus.getHeight();
        this.Slice1 = 1;
        this.Slice2 = imageStack.getSize();
        imageCanvas.addMouseListener((MouseListener)this);
        imageCanvas.addMouseMotionListener((MouseMotionListener)this);
        FileInfo fileInfo = this.imagePlus.getOriginalFileInfo();
        Calibration calibration = this.imagePlus.getCalibration();
        int n2 = imageStack.getSize();
        int n3 = this.imagePlus.getWidth();
        int n4 = this.imagePlus.getHeight();
        byte[] byArray2 = new byte[n3 * n4];
        byte[] byArray3 = new byte[n3 * n4 * n2];
        float[] fArray = new float[n3 * n4 * n2];
        for (int i = 0; i < n2; ++i) {
            ByteProcessor byteProcessor2 = (ByteProcessor)imageStack.getProcessor(i + 1);
            byArray2 = (byte[])byteProcessor2.getPixels();
            for (int j = 0; j < n3 * n4; ++j) {
                byArray3[n3 * n4 * i + j] = byArray2[j];
            }
        }
        GenericDialog genericDialog = new GenericDialog("Optimally Oriented Flux Options");
        double d = Math.abs(calibration.pixelWidth);
        genericDialog.addNumericField("Number of scales", 1.0, 0);
        genericDialog.addNumericField("Minimum scale", d, 6);
        genericDialog.addNumericField("Maximum scale", d, 6);
        genericDialog.addCheckbox("Show Gaussian smoothed images:", false);
        genericDialog.addCheckbox("Show filtered images at each scale:", false);
        genericDialog.addCheckbox("Show which scales were used at each point:", false);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        int n5 = (int)Math.round(genericDialog.getNextNumber());
        if (n5 < 1) {
            IJ.error((String)"The minimum number of scales to try is 1");
            return;
        }
        double d2 = genericDialog.getNextNumber();
        double d3 = genericDialog.getNextNumber();
        if (d3 < d2) {
            IJ.error((String)"The maximum scale cannot be less than the minimum scale");
            return;
        }
        boolean bl = genericDialog.getNextBoolean();
        boolean bl2 = genericDialog.getNextBoolean();
        boolean bl3 = genericDialog.getNextBoolean();
        String string2 = this.getSavePath(fileInfo);
        System.out.println("writing to outputFilename:" + string2);
        this.ti.OrientedFlux(byArray3, fArray, n, n3, n4, n2, calibration.pixelWidth, calibration.pixelHeight, calibration.pixelDepth, d2, d3, n5, string2);
        ImageStack imageStack2 = new ImageStack(n3, n4);
        for (int i = 0; i < n2; ++i) {
            float[] fArray2 = new float[n3 * n4];
            float f = -10.0f;
            float f2 = 10.0f;
            for (int j = 0; j < n3 * n4; ++j) {
                fArray2[j] = fArray[n3 * n4 * i + j];
                if (fArray2[j] > f) {
                    f = fArray2[j];
                }
                if (!(fArray2[j] < f2)) continue;
                f2 = fArray2[j];
            }
            FloatProcessor floatProcessor = new FloatProcessor(n3, n4, fArray2, null);
            imageStack2.addSlice("", (ImageProcessor)floatProcessor);
        }
        ImagePlus imagePlus = new ImagePlus("Tubularity", imageStack2);
        imagePlus.setFileInfo(fileInfo);
        imagePlus.setCalibration(this.imagePlus.getCalibration());
        imagePlus.show();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.p = mouseEvent.getPoint();
        if (this.ROIpt_1_2) {
            this.Slice1 = this.imagePlus.getCurrentSlice();
            this.ROI_p1.x = this.p.x;
            this.ROI_p1.y = this.p.y;
            this.ROIpt_1_2 = false;
            IJ.error((String)("Position 1: " + this.p.x + " " + this.p.y + " " + this.Slice1));
        } else {
            this.Slice2 = this.imagePlus.getCurrentSlice();
            this.ROI_p2.x = this.p.x;
            this.ROI_p2.y = this.p.y;
            this.ROIpt_1_2 = true;
            this.position_checked = true;
            IJ.error((String)("Position 2: " + this.p.x + " " + this.p.y + " " + this.Slice2));
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.p = null;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.p = mouseEvent.getPoint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

