/*
 * Decompiled with CFR 0.152.
 */
package fiji.jni;

import ij.IJ;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;

public class LibraryLoader {
    protected static File libraryDirectory;
    protected static HashSet<String> librariesLoaded;
    protected String baseURL;

    protected LibraryLoader() {
        String string;
        if (this.baseURL == null) {
            String string2;
            string = this.getClass().getName().replace('.', '/') + ".class";
            URL uRL = this.getClass().getResource("/" + string);
            if (uRL != null && (string2 = uRL.toString()).endsWith(string)) {
                this.baseURL = string2.substring(0, string2.length() - string.length());
            }
        }
        if (!librariesLoaded.contains(string = this.getClassBasename())) {
            this.loadLibrary(string);
            librariesLoaded.add(string);
        }
    }

    protected static String getPlatform() {
        return IJ.isMacOSX() ? "macosx" : (IJ.isWindows() ? "win" + (IJ.is64Bit() ? "64" : "32") : "linux" + (IJ.is64Bit() ? "64" : ""));
    }

    protected static String getLibraryName(String string) {
        return (IJ.isWindows() ? "" : "lib") + string + "." + (IJ.isMacOSX() ? "dylib" : (IJ.isWindows() ? "dll" : "so"));
    }

    protected static File getLibraryDirectory() {
        if ("1.46m".compareTo("1.43d") < 0) {
            return new File(IJ.getDirectory((String)"plugins")).getParentFile();
        }
        return new File(IJ.getDirectory((String)"imagej"), "lib" + File.separator + LibraryLoader.getPlatform());
    }

    protected static File getTempLibraryDirectory(String string) {
        try {
            File file = File.createTempFile(string, "");
            if (!file.delete() || !file.mkdirs()) {
                return null;
            }
            file.deleteOnExit();
            return file;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected String getClassBasename() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    protected void loadLibrary(String string) {
        File file;
        String string2 = LibraryLoader.getLibraryName(string);
        if (libraryDirectory == null) {
            libraryDirectory = LibraryLoader.getLibraryDirectory();
        }
        if (!(file = new File(libraryDirectory, string2)).exists()) {
            if (this.baseURL == null) {
                throw new RuntimeException("Could not determine .jar");
            }
            try {
                URL uRL = new URL(this.baseURL + LibraryLoader.getPlatform() + "/" + string2);
                try {
                    LibraryLoader.copy(uRL, file);
                }
                catch (IOException iOException) {
                    libraryDirectory = LibraryLoader.getTempLibraryDirectory(string);
                    file = new File(libraryDirectory, string2);
                    LibraryLoader.copy(uRL, file);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not extract " + string2 + ": " + exception);
            }
        }
        System.load(file.getAbsolutePath());
    }

    protected static void copy(URL uRL, File file) throws IOException {
        int n;
        InputStream inputStream = uRL.openStream();
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[65536];
        while ((n = inputStream.read(byArray)) >= 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        inputStream.close();
        ((OutputStream)fileOutputStream).close();
    }

    static {
        librariesLoaded = new HashSet();
    }
}

