#include "ch.h"
#include "hal.h"
#include "salamandra.h"
#include "chprintf.h"
#include "joystick.h"
#include "radio_reg_op.h"
#include "error.h"

void salamandra_connect(uint8_t channel)
{
  uint8_t result = 0;
 
  while (result != channel) {
    set_reg_b(REG_INTF_CH, channel);
         
    if (!get_reg_b(REG_RWL_CH, &result))
      chprintf((BaseChannel *) &SD1, "Robot not found.\r\n");
    else
      chprintf((BaseChannel *) &SD1, "Wrong answered channel.\r\n");
  }
  
  chprintf((BaseChannel *) &SD1, "Robot connected on channel %d\r\n", result);
}

uint8_t salamandra_init(char error_msg[])
{
  uint8_t channel = 108;
  uint8_t version;
  uint8_t elc;
  uint8_t mode;
  uint8_t i;
  
  salamandra_connect(channel);
  
  while (!get_reg_b(REGB_VER, &version)) {
    chprintf((BaseChannel *) &SD1, "Communication error.\r\n");
  }

  if (version != 5 && version != 2) {
    chprintf((BaseChannel *) &SD1, "Incorrect version : %d.\r\n", version);
    send_error_msg("Incorrect version", error_msg);
    return 0;
  }

  chprintf((BaseChannel *) &SD1, "Robot version : %d.\r\n", version);

  set_reg_b(REGB_AMPL_B, 0);
  set_reg_b(REGB_AMPL_L, 0);
  set_reg_b(REGB_FREQ_B, 0);
  set_reg_b(REGB_FREQ_L, 0);
  set_reg_b(REGB_TURN, (9 << 4) | 8);

  if (!get_reg_b(REGB_ELCOUNT, &elc)) {
    chprintf((BaseChannel *) &SD1, "Communication error.\r\n");
    send_error_msg("Communication error", error_msg);
    return 0;
  }

  chprintf((BaseChannel *) &SD1, "Detected element, count: %u.\r\n", elc);

  if (!get_reg_b(REGB_MODE, &mode)) {
    chprintf((BaseChannel *) &SD1, "Communication error.\r\n");
    send_error_msg("Communication error", error_msg);
    return 0;
  }

  if (mode == 5)
    chprintf((BaseChannel *) &SD1, "Robot already initialized.\r\n");
  else {
    chprintf((BaseChannel *) &SD1, "Initializing el.\r\n");
    set_reg_b(REGB_MODE, 1);
    
    if (!get_reg_b(REGB_MODE, &mode)) {
      chprintf((BaseChannel *) &SD1, "Communication error.\r\n");
      send_error_msg("Communication error", error_msg);
      return 0;
    }

    while(mode == 1) {
      chThdSleepMilliseconds(100);
      if (!get_reg_b(REGB_MODE, &mode)) {
	chprintf((BaseChannel *) &SD1, "Communication error.\r\n");
	send_error_msg("Communication error", error_msg);
	return 0;
      }
    }

    chprintf((BaseChannel *) &SD1, "OK\r\n");
    chprintf((BaseChannel *) &SD1, "Enabling CPG...\r\n");

    for(i=0; i<3; i++) {
      set_reg_b(REGB_MODE, 5);
      get_reg_b(REGB_MODE, &mode);
      if(mode == 5)
	break;
    }
    
    while(mode != 5) {
      set_reg_b(REGB_MODE, 5);
      if (!get_reg_b(REGB_MODE, &mode)) {
	chprintf((BaseChannel *) &SD1, "Communication error.\r\n");
	send_error_msg("Communication error", error_msg);
	return 0;
      }
    }

    chprintf((BaseChannel *) &SD1, "OK\r\n");

    set_reg_b(REGB_PHASE, 255/2); 
  }

  if (mode == 5)
    chprintf((BaseChannel *) &SD1, "Salamandra initialization successful\r\n");
  
  joystick_init();

  return (mode == 5);
}

void salamandra_stop(void)
{
  uint8_t mode;

  set_reg_b(REGB_AMPL_L, 0);
  set_reg_b(REGB_AMPL_B, 0);
  set_reg_b(REGB_FREQ_L, 0);
  set_reg_b(REGB_FREQ_B, 0);
  
  chThdSleepMilliseconds(500);

  set_reg_b(REGB_MODE, 3);
  mode = 3;

  while (mode != 0) {
    chThdSleepMilliseconds(100);
    get_reg_b(REGB_MODE, &mode);
  }

  joystick_stop();
}
