#include "ch.h"
#include "hal.h"
#include "chprintf.h"
#include "radio_reg_op.h"

/*
 * REGISTERS OPERATIONS : originally coded by Gabriel Cuendet, enhanced by Matthieu Tardivon
 */

/*
 * Basic register operation
 */
uint8_t reg_op(uint8_t op, uint16_t addr, uint8_t *data, uint8_t length)
{
  uint8_t confirm = 13;
  uint8_t i;
  uint8_t buffer[32];
  
  buffer[0] = (op << 2) | ((addr & 0x300) >> 8);
  buffer[1] = (addr & 0xFF);
  for(i=0; i<length; i++)
     buffer[i+2] = data[i];
  for(i=0; i<length+2; i++)
    chprintf((BaseChannel *) &SD2, "%c", buffer[i]);
  
  confirm = chIOGet((BaseChannel *) &SD2);
  return (confirm == 6);
}

/*
 * Getter for a 8 bits register located at the specified address
 */
uint8_t get_reg_b(uint16_t addr, uint8_t *result)
{
  if(reg_op(0x00, addr, 0, 0)) {
    *result = chIOGet((BaseChannel *) &SD2);
    return REG_OP_OK;
  }
   
  return REG_OP_ERROR;
}

/*
 * Getter for a 16 bits register located at the specified address
 */
uint8_t get_reg_w(uint16_t addr, uint16_t *result)
{
  uint8_t buffer[2] __attribute__((aligned(2)));
   
  if(reg_op(0x01, addr, 0, 0)) {
    buffer[0] = chIOGet((BaseChannel *) &SD2);
    buffer[1] = chIOGet((BaseChannel *) &SD2);
      
    *result = *((uint16_t *) buffer);
    return REG_OP_OK;
  }
   
  return REG_OP_ERROR;
}

/*
 * Getter for a 32 bits register located at the specified address 
 */
uint8_t get_reg_dw(uint16_t addr, uint32_t *result)
{
  uint8_t buffer[4] __attribute__((aligned(4)));

  if(reg_op(0x02, addr, 0, 0)) {
    buffer[0] = chIOGet((BaseChannel *) &SD2);
    buffer[1] = chIOGet((BaseChannel *) &SD2);
    buffer[2] = chIOGet((BaseChannel *) &SD2);
    buffer[3] = chIOGet((BaseChannel *) &SD2);

    *result = *((uint32_t *) buffer);
    return REG_OP_OK;
  }
   
  return REG_OP_ERROR;
}

/*
 * Getter for a various length's register at the specified address
 */
uint8_t get_reg_mb(uint16_t addr, uint8_t *length, uint8_t *result)
{
  uint8_t i;
  uint8_t buffer[32];
   
  if(reg_op(0x03, addr, 0, 0)) {
    *length = chIOGet((BaseChannel *) &SD2);
   
    for(i=0; i<*length; i++)
      buffer[i] = chIOGet((BaseChannel *) &SD2); 
   
    /////////////////////////////
    // TODO : Check the validity, probably very wrong !!!
    /////////////////////////////
    *result = buffer;
    return REG_OP_OK;
  }
   
  return REG_OP_ERROR;
}
   
/*
 * Setter for a 8 bits register located at the specified address
 */
uint8_t set_reg_b(uint16_t addr, uint8_t data)
{
  return reg_op(0x04, addr, &data, 1);
}


/*
 * Setter for a 16 bits register located at the specified address
 */
uint8_t set_reg_w(uint16_t addr, uint16_t data)
{
  return reg_op(0x05, addr, (uint8_t *) &data, 2);
}


/*
 * Setter for a 32 bits register located at the specified address
 */
uint8_t set_reg_dw(uint16_t addr, uint32_t data)
{
  return reg_op(0x06, addr, (uint8_t *) &data, 4);
}


/*
 * Setter for a multi bytes register located at the specified address
 */
uint8_t set_reg_mb(uint16_t addr, uint8_t *data, uint8_t length)
{
  uint8_t buffer[32];
  uint8_t i;
   
  /// Tests the length : cannot be over 29 (cf. structure of a multi-bytes reg)
  if(length > 29)
    return REG_OP_ERROR;
   
   
  buffer[0] = length;
  for(i=0; i<length ; i++)
    buffer[i+1] = data[i];
   
  return reg_op(0x07, addr, buffer, length + 1);
}
