#include "ch.h"
#include "hal.h"
#include "chprintf.h"
#include "ff.h"
#include "mmc.h"
#include "lcd.h"
#include "error.h"

MMCDriver MMCD1;
static FATFS MMC_FS;

static const SPIConfig hs_spi2cfg =
  {
    NULL,
    GPIOB,
    12,
    SPI_CR1_BR_0,
  };

static const SPIConfig ls_spi2cfg =
  {
    NULL,
    GPIOB,
    12,
    SPI_CR1_BR_2 | SPI_CR1_BR_1
  };

bool_t mmc_is_inserted(void)
{
  return !palReadPad(GPIOA, 11);
}

bool_t mmc_is_protected(void)
{
  return palReadPad(GPIOA, 12);
}
uint8_t mmc_init(char error_msg[])
{
  lcd_clear_display(2);

  if (mmc_is_inserted()) {
    lcd_set_position(0, 0);
    lcd_puts("SDCard detected");
  }

  if (mmc_is_protected()) {
    lcd_set_position(1, 0);
    lcd_puts("SDCard protected");
  }
  
  mmcObjectInit(&MMCD1, &SPID2, &ls_spi2cfg, &hs_spi2cfg, mmc_is_protected, mmc_is_inserted);
  mmcStart(&MMCD1, NULL);
  chThdSleep(100);

  if(mmcConnect(&MMCD1)) {
    send_error_msg("SD Card needed...", error_msg);
    return 0;
  }
  
  f_mount(0, &MMC_FS);
  lcd_clear_display(2);
  lcd_set_position(0, 0);
  lcd_puts("SDCard connected");

  return 1;
}

void mmc_list_folders(void) {
  DIR dir;
  f_opendir(&dir, "0:");
  while(1) {
    FILINFO fno;
    int res = f_readdir(&dir, &fno);
    if(res != FR_OK || fno.fname[0]==0)
      break;
    chprintf((BaseChannel *) &SD1, "-> %s\r\n", fno.fname);
  }
}

void mmc_cat_file(char *filename)
{
  FIL file;
  char buffer[1];
  UINT result = 0;
  
  if (f_open(&file, filename, FA_OPEN_EXISTING | FA_READ) != FR_OK) {
    chprintf((BaseChannel *) &SD1, "File not found !\r\n");
    return;
  }
  
  chprintf((BaseChannel *) &SD1, "Fichier : %s\r\n", filename);
  
  while (!f_eof(&file)) {
    f_read(&file, buffer, sizeof(buffer), &result);
    chprintf((BaseChannel *) &SD1, "%c", buffer[0]);
  }
}
