#include "ch.h"
#include "hal.h"
///*
#include "lcd.h"
#include "buzzer.h"
#include "mmc.h"
#include "zigbee.h"
#include "joystick.h"
#include "rf_comm.h"
#include "remote_flash.h"
#include "salamandra.h"
//*/
#include "buttons.h"
#include "menu.h"

#define SERIAL_DEBUG
//#define BLINKING_WHITE

/*
 * Application entry point.
 */
int main(void) {

  /*
   * System initializations.
   * - HAL initialization, this also initializes the configured device drivers
   *   and performs the board-specific initializations.
   * - Kernel initialization, the main() function becomes a thread and the
   *   RTOS is active.
   */
  halInit();
  chSysInit();

#ifdef SERIAL_DEBUG
  sdStart(&SD1, NULL);
#endif

  buttons_init();
  menu_init();
  //buzzer_init();
  //play_mario();
  //mmc_init();
  //zigbee_init();
  //joystick_init();
  //rf_comm_init();
  //remote_flash();
  //salamandra_init();
  
  /*
   * Normal main() thread activity.
   */
  while (TRUE) {
#ifdef BLINKING_WHITE
    palClearPad(GPIOA, 7); //Red LED
    palClearPad(GPIOB, 0); //Green LED
    palClearPad(GPIOB, 1); //Blue LED
    chThdSleepMilliseconds(1000);
    palSetPad(GPIOA, 7);
    palSetPad(GPIOB, 0);
    palSetPad(GPIOB, 1);
#endif
    chThdSleepMilliseconds(1000);
  }
  
  return 0;
}
